---
UID: NF:dxva2api.DXVA2FloatToFixed
title: DXVA2FloatToFixed function (dxva2api.h)
description: Converts a floating-point number to a DXVA2_Fixed32 value.
old-location: mf\dxva2floattofixed.htm
tech.root: medfound
ms.assetid: 2537e691-2137-4e4b-90a0-6749a6ceb144
ms.date: 12/05/2018
ms.keywords: 2537e691-2137-4e4b-90a0-6749a6ceb144, DXVA2FloatToFixed, DXVA2FloatToFixed function [Media Foundation], dxva2api/DXVA2FloatToFixed, mf.dxva2floattofixed
f1_keywords:
- dxva2api/DXVA2FloatToFixed
dev_langs:
- c++
req.header: dxva2api.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva2api.h
api_name:
- DXVA2FloatToFixed
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# DXVA2FloatToFixed function


## -description



Converts a floating-point number to a <a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> value.




## -parameters




### -param _float_ [in]

Floating-point number to convert to a fixed-point value.


## -returns



The function returns a <a href="https://docs.microsoft.com/windows/desktop/api/dxva2api/ns-dxva2api-dxva2_fixed32">DXVA2_Fixed32</a> structure that contains the converted fixed-point value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-functions">Media Foundation Functions</a>
 

 

