---
UID: NE:dxva9typ._COPP_ACP_Protection_Level
title: COPP_ACP_Protection_Level (dxva9typ.h)
description: Specifies the ACP protection level.
old-location: dshow\copp_acp_protection_level.htm
tech.root: DirectShow
ms.assetid: a3149eb6-e758-4b21-b574-32fb6c2ae3a2
ms.date: 12/05/2018
ms.keywords: COPP_ACP_ForceDWORD, COPP_ACP_Level0, COPP_ACP_Level1, COPP_ACP_Level2, COPP_ACP_Level3, COPP_ACP_LevelMax, COPP_ACP_LevelMin, COPP_ACP_Protection_Level, COPP_ACP_Protection_Level , COPP_ACP_Protection_Level enumeration [DirectShow], COPP_ACP_Protection_LevelEnumeration, dshow.copp_acp_protection_level, dxva9typ/COPP_ACP_ForceDWORD, dxva9typ/COPP_ACP_Level0, dxva9typ/COPP_ACP_Level1, dxva9typ/COPP_ACP_Level2, dxva9typ/COPP_ACP_Level3, dxva9typ/COPP_ACP_LevelMax, dxva9typ/COPP_ACP_LevelMin, dxva9typ/COPP_ACP_Protection_Level
f1_keywords:
- dxva9typ/COPP_ACP_Protection_Level
dev_langs:
- c++
req.header: dxva9typ.h
req.include-header: Dxva.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva9typ.h
api_name:
- COPP_ACP_Protection_Level
targetos: Windows
req.typenames: COPP_ACP_Protection_Level
req.redist: 
ms.custom: 19H1
---

# COPP_ACP_Protection_Level enumeration


## -description



Specifies the ACP protection level.




## -enum-fields




### -field COPP_ACP_Level0

Level 0.
          


### -field COPP_ACP_LevelMin

Minimum ACP level. Equivalent to <b>COPP_ACP_Level0</b>.
          


### -field COPP_ACP_Level1

Level 1.
          


### -field COPP_ACP_Level2

Level 2.
          


### -field COPP_ACP_Level3

Level 3.
          


### -field COPP_ACP_LevelMax

Maximum ACP level. Equivalent to <b>COPP_ACP_Level3</b>.
          


### -field COPP_ACP_ForceDWORD

Reserved.
          


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/DirectShow/using-certified-output-protection-protocol--copp">Using Certified Output Protection Protocol (COPP)</a>
 

 

