---
UID: NE:dxva9typ._COPP_ImageAspectRatio_EN300294
title: COPP_ImageAspectRatio_EN300294 (dxva9typ.h)
description: Specifies the aspect ratio for EN 300 294.
old-location: dshow\copp_imageaspectratio_en300294.htm
tech.root: DirectShow
ms.assetid: 9beb172c-6255-482b-90cc-a32b2e5d3bec
ms.date: 12/05/2018
ms.keywords: COPP_AspectRatio_EN300294_Box14by9Center, COPP_AspectRatio_EN300294_Box14by9Top, COPP_AspectRatio_EN300294_Box16by9Center, COPP_AspectRatio_EN300294_Box16by9Top, COPP_AspectRatio_EN300294_BoxGT16by9Center, COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic, COPP_AspectRatio_EN300294_FullFormat4by3, COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter, COPP_ImageAspectRatio_EN300294, COPP_ImageAspectRatio_EN300294 , COPP_ImageAspectRatio_EN300294 enumeration [DirectShow], COPP_ImageAspectRatio_EN300294Enumeration, dshow.copp_imageaspectratio_en300294, dxva9typ/COPP_AspectRatio_EN300294_Box14by9Center, dxva9typ/COPP_AspectRatio_EN300294_Box14by9Top, dxva9typ/COPP_AspectRatio_EN300294_Box16by9Center, dxva9typ/COPP_AspectRatio_EN300294_Box16by9Top, dxva9typ/COPP_AspectRatio_EN300294_BoxGT16by9Center, dxva9typ/COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic, dxva9typ/COPP_AspectRatio_EN300294_FullFormat4by3, dxva9typ/COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter, dxva9typ/COPP_ImageAspectRatio_EN300294
f1_keywords:
- dxva9typ/COPP_ImageAspectRatio_EN300294
dev_langs:
- c++
req.header: dxva9typ.h
req.include-header: Dxva.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva9typ.h
api_name:
- COPP_ImageAspectRatio_EN300294
targetos: Windows
req.typenames: COPP_ImageAspectRatio_EN300294
req.redist: 
ms.custom: 19H1
---

# COPP_ImageAspectRatio_EN300294 enumeration


## -description



Specifies the aspect ratio for EN 300 294.




## -enum-fields




### -field COPP_AspectRatio_EN300294_FullFormat4by3

Full format 4:3.
          


### -field COPP_AspectRatio_EN300294_Box14by9Center

Box 14:9 center.
          


### -field COPP_AspectRatio_EN300294_Box14by9Top

Box 14:9 top.
          


### -field COPP_AspectRatio_EN300294_Box16by9Center

Box 16:9 center.
          


### -field COPP_AspectRatio_EN300294_Box16by9Top

Box 16:9 top.
          


### -field COPP_AspectRatio_EN300294_BoxGT16by9Center

Box &gt; 16:9 center.
          


### -field COPP_AspectRatio_EN300294_FullFormat4by3ProtectedCenter

Full format 4:3 (shoot and protect 14:9 center).
          


### -field COPP_AspectRatio_EN300294_FullFormat16by9Anamorphic

Full format 16:9 (anamorphic)
          


### -field COPP_AspectRatio_ForceDWORD




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/DirectShow/using-certified-output-protection-protocol--copp">Using Certified Output Protection Protocol (COPP)</a>
 

 

