---
UID: NE:dxva9typ._COPP_TVProtectionStandard
title: COPP_TVProtectionStandard (dxva9typ.h)
description: Defines a list of TV protection standards for Certified Output Protection Protocol (COPP).
old-location: dshow\copp_tvprotectionstandard.htm
tech.root: DirectShow
ms.assetid: 3a724f93-8625-4594-a45b-c2e4c882b579
ms.date: 12/05/2018
ms.keywords: COPP_ProtectionStandard_ARIBTRB15_1125i, COPP_ProtectionStandard_ARIBTRB15_525i, COPP_ProtectionStandard_ARIBTRB15_525p, COPP_ProtectionStandard_ARIBTRB15_750p, COPP_ProtectionStandard_CEA805A_TypeA_1125i, COPP_ProtectionStandard_CEA805A_TypeA_525p, COPP_ProtectionStandard_CEA805A_TypeA_750p, COPP_ProtectionStandard_CEA805A_TypeB_1125i, COPP_ProtectionStandard_CEA805A_TypeB_525p, COPP_ProtectionStandard_CEA805A_TypeB_750p, COPP_ProtectionStandard_EIA608B_525, COPP_ProtectionStandard_EN300294_625i, COPP_ProtectionStandard_IEC61880_2_525i, COPP_ProtectionStandard_IEC61880_525i, COPP_ProtectionStandard_IEC62375_625p, COPP_ProtectionStandard_Mask, COPP_ProtectionStandard_None, COPP_ProtectionStandard_Reserved, COPP_ProtectionStandard_Unknown, COPP_TVProtectionStandard, COPP_TVProtectionStandard , COPP_TVProtectionStandard enumeration [DirectShow], COPP_TVProtectionStandardEnumeration, dshow.copp_tvprotectionstandard, dxva9typ/COPP_ProtectionStandard_ARIBTRB15_1125i, dxva9typ/COPP_ProtectionStandard_ARIBTRB15_525i, dxva9typ/COPP_ProtectionStandard_ARIBTRB15_525p, dxva9typ/COPP_ProtectionStandard_ARIBTRB15_750p, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeA_1125i, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeA_525p, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeA_750p, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeB_1125i, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeB_525p, dxva9typ/COPP_ProtectionStandard_CEA805A_TypeB_750p, dxva9typ/COPP_ProtectionStandard_EIA608B_525, dxva9typ/COPP_ProtectionStandard_EN300294_625i, dxva9typ/COPP_ProtectionStandard_IEC61880_2_525i, dxva9typ/COPP_ProtectionStandard_IEC61880_525i, dxva9typ/COPP_ProtectionStandard_IEC62375_625p, dxva9typ/COPP_ProtectionStandard_Mask, dxva9typ/COPP_ProtectionStandard_None, dxva9typ/COPP_ProtectionStandard_Reserved, dxva9typ/COPP_ProtectionStandard_Unknown, dxva9typ/COPP_TVProtectionStandard
f1_keywords:
- dxva9typ/COPP_TVProtectionStandard
dev_langs:
- c++
req.header: dxva9typ.h
req.include-header: Dxva.h
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxva9typ.h
api_name:
- COPP_TVProtectionStandard
targetos: Windows
req.typenames: COPP_TVProtectionStandard
req.redist: 
ms.custom: 19H1
---

# COPP_TVProtectionStandard enumeration


## -description



Defines a list of TV protection standards
      for Certified Output Protection Protocol (COPP).
          
        




## -enum-fields




### -field COPP_ProtectionStandard_Unknown

None.
          


### -field COPP_ProtectionStandard_None

Unknown.
          


### -field COPP_ProtectionStandard_IEC61880_525i

IEC 61880, 525i.
          


### -field COPP_ProtectionStandard_IEC61880_2_525i

IEC 61880-2, 525i.
          


### -field COPP_ProtectionStandard_IEC62375_625p

IEC 62375, 625p.
          


### -field COPP_ProtectionStandard_EIA608B_525

EIA/CEA-608-B, 525i.
          


### -field COPP_ProtectionStandard_EN300294_625i

ETSI EN 300 294, 625i.
          


### -field COPP_ProtectionStandard_CEA805A_TypeA_525p

CEA-805-A Type A, 525p.
          


### -field COPP_ProtectionStandard_CEA805A_TypeA_750p

CEA-805-A Type A, 750p.
          


### -field COPP_ProtectionStandard_CEA805A_TypeA_1125i

CEA-805-A Type A, 1125i.
          


### -field COPP_ProtectionStandard_CEA805A_TypeB_525p

CEA-805-A Type B, 525p.
          


### -field COPP_ProtectionStandard_CEA805A_TypeB_750p

CEA-805-A Type B, 750p.
          


### -field COPP_ProtectionStandard_CEA805A_TypeB_1125i

CEA-805-A Type B, 1125i.
          


### -field COPP_ProtectionStandard_ARIBTRB15_525i

ARIB TR-B15, 525i.
          


### -field COPP_ProtectionStandard_ARIBTRB15_525p

ARIB TR-B15, 525p.
          


### -field COPP_ProtectionStandard_ARIBTRB15_750p

ARIB TR-B15, 750p.
          


### -field COPP_ProtectionStandard_ARIBTRB15_1125i

ARIB TR-B15, 1125i.
          


### -field COPP_ProtectionStandard_Mask

Reserved.
          


### -field COPP_ProtectionStandard_Reserved

Reserved.
          


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/DirectShow/directshow-enumerated-types">DirectShow Enumerated Types</a>



<a href="https://docs.microsoft.com/windows/desktop/DirectShow/using-certified-output-protection-protocol--copp">Using Certified Output Protection Protocol (COPP)</a>
 

 

