---
UID: NE:dxvahd._DXVAHD_FILTER
title: DXVAHD_FILTER (dxvahd.h)
description: Specifies image filters for Microsoft DirectX Video Acceleration High Definition (DXVA-HD) video processing.
old-location: mf\dxvahd_filter.htm
tech.root: medfound
ms.assetid: e6abac04-c8cb-4130-b48e-fb5d25794d62
ms.date: 12/05/2018
ms.keywords: DXVAHD_FILTER, DXVAHD_FILTER enumeration [Media Foundation], DXVAHD_FILTER_ANAMORPHIC_SCALING, DXVAHD_FILTER_BRIGHTNESS, DXVAHD_FILTER_CONTRAST, DXVAHD_FILTER_EDGE_ENHANCEMENT, DXVAHD_FILTER_HUE, DXVAHD_FILTER_NOISE_REDUCTION, DXVAHD_FILTER_SATURATION, dxvahd/DXVAHD_FILTER, dxvahd/DXVAHD_FILTER_ANAMORPHIC_SCALING, dxvahd/DXVAHD_FILTER_BRIGHTNESS, dxvahd/DXVAHD_FILTER_CONTRAST, dxvahd/DXVAHD_FILTER_EDGE_ENHANCEMENT, dxvahd/DXVAHD_FILTER_HUE, dxvahd/DXVAHD_FILTER_NOISE_REDUCTION, dxvahd/DXVAHD_FILTER_SATURATION, mf.dxvahd_filter
f1_keywords:
- dxvahd/DXVAHD_FILTER
dev_langs:
- c++
req.header: dxvahd.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- dxvahd.h
api_name:
- DXVAHD_FILTER
targetos: Windows
req.typenames: DXVAHD_FILTER
req.redist: 
ms.custom: 19H1
---

# DXVAHD_FILTER enumeration


## -description


Specifies image filters for Microsoft DirectX Video Acceleration High Definition (DXVA-HD) video processing.


## -enum-fields




### -field DXVAHD_FILTER_BRIGHTNESS

Adjusts brightness.


### -field DXVAHD_FILTER_CONTRAST

Adjusts contrast.


### -field DXVAHD_FILTER_HUE

Adjusts hue.


### -field DXVAHD_FILTER_SATURATION

Adjusts saturation.


### -field DXVAHD_FILTER_NOISE_REDUCTION

Applies noise reduction.


### -field DXVAHD_FILTER_EDGE_ENHANCEMENT

Applies edge enhancement.


### -field DXVAHD_FILTER_ANAMORPHIC_SCALING

Performs <i>anamorphic scaling</i>. Anamorphic scaling can be used to stretch 4:3 content to a widescreen 16:9 aspect ratio.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/medfound/dxva-hd">DXVA-HD</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/direct3d-video-enumerations">Direct3D Video Enumerations</a>



<a href="https://docs.microsoft.com/windows/desktop/medfound/media-foundation-enumerations">Media Foundation Enumerations</a>
 

 

