---
UID: NF:eaphostpeerconfigapis.EapHostPeerCredentialsXml2Blob
title: EapHostPeerCredentialsXml2Blob function (eaphostpeerconfigapis.h)
description: Generates the credentials BLOB.
old-location: eaphost\eaphostpeercredentialsxml2blob.htm
tech.root: eaphost
ms.assetid: ef8475f0-047d-4858-b3c1-3ddf41c1847f
ms.date: 12/05/2018
ms.keywords: EapHostPeerCredentialsXml2Blob, EapHostPeerCredentialsXml2Blob function [EAPHost], eaphost.eaphostpeercredentialsxml2blob, eaphostpeerconfigapis/EapHostPeerCredentialsXml2Blob
f1_keywords:
- eaphostpeerconfigapis/EapHostPeerCredentialsXml2Blob
dev_langs:
- c++
req.header: eaphostpeerconfigapis.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Eappcfg.lib
req.dll: Eappcfg.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- eappcfg.dll
api_name:
- EapHostPeerCredentialsXml2Blob
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# EapHostPeerCredentialsXml2Blob function


## -description


Generates the credentials  BLOB.   The credentials BLOB contains only user data such as user name, password, and PIN. A configuration BLOB, in contrast, contains the settings that control the behavior of the method.


## -parameters




### -param dwFlags [in]

Not used. Set to 0.


### -param pCredentialsDoc [in]

 A pointer to an XML node of a document that contains credentials which are either user or machine credentials depending on the configuration passed in. The XML document is created with the [EapHostUserCredentials Schema](https://docs.microsoft.com/windows/win32/eaphost/eaphostusercredentialsschema-schema)a>.


### -param dwSizeOfConfigIn [in]

The size, in bytes, of the buffer pointed to by the <i>pConfigIn</i> parameter. 


### -param pConfigIn [in]

A pointer to a byte buffer that contains a configuration BLOB for which the credentials are configured. The  buffer is of size <i>dwSizeofConfigIn</i>.


### -param pdwSizeOfCredentialsOut [out]

The size, in bytes, of the buffer pointed to by <i>ppCredentialsOut</i>.


### -param ppCredentialsOut [out]

A pointer to a pointer to a byte buffer that receives the credentials BLOB buffer generated by the input XML. The buffer can is of size <i>pdwSizeofCredentialsOut</i>. After consuming the data, this memory must be freed by calling  <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeerfreememory">EapHostPeerFreeMemory</a>. 


### -param pEapMethodType [out]

A pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_type">EAP_METHOD_TYPE</a> structure referred to in the XML document.


### -param ppEapError [out]

A pointer to a pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_error">EAP_ERROR</a> structure that contains any errors raised  by EAPHost during  the execution of this function call. After consuming the error data, this memory must be freed by calling <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eappapis/nf-eappapis-eaphostpeerfreeeaperror">EapHostPeerFreeErrorMemory</a>.


## -remarks



The configuration BLOB is originally returned by one of the following methods.

<ul>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeerconfigxml2blob">EapHostPeerConfigXml2Blob</a>
</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeerinvokeconfigui">EapHostPeerInvokeConfigUI</a>
</li>
<li>
<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eappapis/nf-eappapis-eaphostpeergetresult">EapHostPeerGetResult</a>
</li>
</ul>
 The XML based credentials can come from group policy or from a system administrator.




## -see-also




[EAPHost Supplicant Configuration Functions](https://docs.microsoft.com/windows/win32/eaphost/eap-host-supplicant-configuration-functions)a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeerconfigxml2blob">EapHostPeerConfigXml2Blob</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eappapis/nf-eappapis-eaphostpeergetresult">EapHostPeerGetResult</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeerinvokeconfigui">EapHostPeerInvokeConfigUI</a>
 

 

