---
UID: NS:eaphostpeertypes.tagEapHostPeerMethodResult
title: EapHostPeerMethodResult (eaphostpeertypes.h)
description: Contains the result data generated by EAPHost during an authentication session that is then passed to an EAP method.
old-location: eaphost\eaphostpeermethodresult.htm
tech.root: eaphost
ms.assetid: 376e5399-61c9-4927-ac68-8a1bb4bdc7db
ms.date: 12/05/2018
ms.keywords: EapHostPeerMethodResult, EapHostPeerMethodResult structure [EAPHost], eaphost.eaphostpeermethodresult, eaphostpeertypes/EapHostPeerMethodResult
f1_keywords:
- eaphostpeertypes/EapHostPeerMethodResult
dev_langs:
- c++
req.header: eaphostpeertypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- eaphostpeertypes.h
api_name:
- EapHostPeerMethodResult
targetos: Windows
req.typenames: EapHostPeerMethodResult
req.redist: 
ms.custom: 19H1
---

# EapHostPeerMethodResult structure


## -description


The <b>EapHostPeerMethodResult</b> structure contains the result data generated by EAPHost during an authentication session that is then passed to an EAP method.


## -struct-fields




### -field fIsSuccess

If <b>TRUE</b>, the supplicant was successfully authenticated; if <b>FALSE</b>, it was not.


### -field dwFailureReasonCode

Contains a reason code if the supplicant could not be authenticated.


### -field fSaveConnectionData

If <b>TRUE</b>, the connection data specified in <b>pConnectionData</b> data must be persisted to disk; otherwise, it does not need to be saved.


### -field dwSizeofConnectionData

The size, in bytes, of <b>pConnectionData</b>.


### -field pConnectionData.size_is

 


### -field pConnectionData.size_is.dwSizeofConnectionData

 


### -field pConnectionData

A pointer to a byte buffer that contains information on the connection over which the EAP authentication session is held.


### -field fSaveUserData

If <b>TRUE</b>, the user data specified in <b>pUserData</b> data must be persisted to disk; otherwise, it does not need to be saved.


### -field dwSizeofUserData

The size, in bytes, of <b>pUserData</b>.


### -field pUserData.size_is

 


### -field pUserData.size_is.dwSizeofUserData

 


### -field pUserData

A pointer to a  byte buffer that contains information on the supplicant user that requested the EAP authentication session.


### -field pAttribArray

Pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attributes">EAP_ATTRIBUTES</a> array structure that contains attributes of the authentication session.


### -field isolationState

An <a href="https://docs.microsoft.com/windows/desktop/api/eaphostpeertypes/ne-eaphostpeertypes-isolation_state">ISOLATION_STATE</a>link value that indicates the isolation state of the authentication session connection.


### -field pEapMethodInfo

A pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_info">EAP_METHOD_INFO</a> structure that contains information about the EAP method that performed authentication for the supplicant.


### -field pEapError

A pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_error">EAP_ERROR</a> structure that contains any errors raised by EAPHost during  the execution of this function call. After consuming the error data, this memory must be freed by calling <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eappapis/nf-eappapis-eaphostpeerfreeeaperror">EapHostPeerFreeEapError</a>.


## -see-also




[EAPHost Supplicant Structures](https://docs.microsoft.com/windows/win32/eaphost/eap-host-supplicant-structures)a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eappapis/nf-eappapis-eaphostpeergetresult">EapHostPeerGetResult</a>
 

 

