---
UID: NS:eapmethodpeerapis.tagEapPeerMethodResult
title: EapPeerMethodResult (eapmethodpeerapis.h)
description: Contains result data generated by an EAP method during authentication.
old-location: eaphost\eappeermethodresult.htm
tech.root: eaphost
ms.assetid: ed6a3560-53a8-4ead-8c6b-8e65c72dafe1
ms.date: 12/05/2018
ms.keywords: EapPeerMethodResult, EapPeerMethodResult structure [EAPHost], eaphost.eappeermethodresult, eapmethodpeerapis/EapPeerMethodResult
f1_keywords:
- eapmethodpeerapis/EapPeerMethodResult
dev_langs:
- c++
req.header: eapmethodpeerapis.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- eapmethodpeerapis.h
api_name:
- EapPeerMethodResult
targetos: Windows
req.typenames: EapPeerMethodResult
req.redist: 
ms.custom: 19H1
---

# EapPeerMethodResult structure


## -description


Contains result data generated by an EAP method during authentication.


## -struct-fields




### -field fIsSuccess

If <b>TRUE</b>, the supplicant was successfully authenticated; if <b>FALSE</b>, it was not.


### -field dwFailureReasonCode

Contains a reason code if the supplicant could not be authenticated.


### -field fSaveConnectionData

If <b>TRUE</b>, the connection data specified in <b>pConnectionData</b> data must be persisted to disk; otherwise, it does not need to be saved.


### -field dwSizeofConnectionData

 


### -field pConnectionData

A pointer to a byte buffer that contains information on the connection over which the EAP authentication session is held. The buffer can contain no more than <i>dwSizeOfConnectionData</i> elements. 


### -field fSaveUserData

If <b>TRUE</b>, the user data specified in <b>pUserData</b> data must be persisted to disk; otherwise, it does not need to be saved.


### -field dwSizeofUserData

The size, in bytes, of <i>pUserData</i>.


### -field pUserData

A pointer to a  byte buffer that contains information on the supplicant user that requested the EAP authentication session.The buffer can contain no more than <i>dwSizeofUserData</i> elements. 


### -field pAttribArray

A pointer to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attributes">EAP_ATTRIBUTES</a> array structure that contains the EAP attributes  returned by the authentication session.


### -field pEapError

A pointer to the <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_error">EAP_ERROR</a> structure that contains any errors raised during  the execution of this function call. After consuming the error data, this memory must be freed by passing a pointer to <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eapmethodpeerapis/nf-eapmethodpeerapis-eappeerfreeerrormemory">EapPeerFreeErrorMemory</a>.


### -field pNgcKerbTicket

 


### -field fSaveToCredMan

 




#### - dwSizeOfConnectionData

The size, in bytes, of <b>pConnectionData</b>.


## -see-also




[EAPHost Peer Method Structures](https://docs.microsoft.com/windows/win32/eaphost/eap-host-peer-method-structures)a>
 

 

