---
UID: NE:eaptypes._EAP_ATTRIBUTE_TYPE
title: EAP_ATTRIBUTE_TYPE (eaptypes.h)
description: Defines the set of possible EAP attribute types available on an authenticating entity.
old-location: eaphost\eap_attribute_type.htm
tech.root: eaphost
ms.assetid: 1c6999f5-b455-4a8d-9967-dc27938e8737
ms.date: 12/05/2018
ms.keywords: EAP_ATTRIBUTE_TYPE, EAP_ATTRIBUTE_TYPE enumeration [EAPHost], EapAttributeType, EapAttributeType enumeration [EAPHost], eaphost.eap_attribute_type, eaptypes/EAP_ATTRIBUTE_TYPE, eaptypes/EapAttributeType, eaptypes/eatARAPChallengeResponse, eaptypes/eatARAPFeatures, eaptypes/eatARAPGuestLogon, eaptypes/eatARAPPassword, eaptypes/eatARAPSecurity, eaptypes/eatARAPSecurityData, eaptypes/eatARAPZoneAccess, eaptypes/eatAcctAuthentic, eaptypes/eatAcctDelayTime, eaptypes/eatAcctEventTimeStamp, eaptypes/eatAcctInputOctets, eaptypes/eatAcctInputPackets, eaptypes/eatAcctInterimInterval, eaptypes/eatAcctLinkCount, eaptypes/eatAcctMultiSessionId, eaptypes/eatAcctOutputOctets, eaptypes/eatAcctOutputPackets, eaptypes/eatAcctSessionId, eaptypes/eatAcctSessionTime, eaptypes/eatAcctStatusType, eaptypes/eatAcctTerminateCause, eaptypes/eatCallbackId, eaptypes/eatCallbackNumber, eaptypes/eatCalledStationId, eaptypes/eatCallingStationId, eaptypes/eatCertificateOID, eaptypes/eatClass, eaptypes/eatClearTextPassword, eaptypes/eatConfigurationToken, eaptypes/eatConnectInfo, eaptypes/eatCredentialsChanged, eaptypes/eatEAPConfiguration, eaptypes/eatEAPMessage, eaptypes/eatEAPTLV, eaptypes/eatEMSK, eaptypes/eatFilterId, eaptypes/eatFramedAppleTalkLink, eaptypes/eatFramedAppleTalkNetwork, eaptypes/eatFramedAppleTalkZone, eaptypes/eatFramedCompression, eaptypes/eatFramedIPAddress, eaptypes/eatFramedIPNetmask, eaptypes/eatFramedIPXNetwork, eaptypes/eatFramedIPv6Pool, eaptypes/eatFramedIPv6Prefix, eaptypes/eatFramedIPv6Route, eaptypes/eatFramedInterfaceId, eaptypes/eatFramedMTU, eaptypes/eatFramedProtocol, eaptypes/eatFramedRoute, eaptypes/eatFramedRouting, eaptypes/eatIdleTimeout, eaptypes/eatInnerEapMethodType, eaptypes/eatLoginIPHost, eaptypes/eatLoginIPv6Host, eaptypes/eatLoginLATGroup, eaptypes/eatLoginLATNode, eaptypes/eatLoginLATPort, eaptypes/eatLoginLATService, eaptypes/eatLoginService, eaptypes/eatLoginTCPPort, eaptypes/eatMD5CHAPChallenge, eaptypes/eatMD5CHAPPassword, eaptypes/eatMethodId, eaptypes/eatMinimum, eaptypes/eatNASIPAddress, eaptypes/eatNASIPv6Address, eaptypes/eatNASIdentifier, eaptypes/eatNASPortType, eaptypes/eatNASport, eaptypes/eatPEAPEmbeddedEAPTypeId, eaptypes/eatPEAPFastRoamedSession, eaptypes/eatPasswordRetry, eaptypes/eatPeerId, eaptypes/eatPortLimit, eaptypes/eatPrompt, eaptypes/eatProxyState, eaptypes/eatQuarantineSoH, eaptypes/eatReplyMessage, eaptypes/eatReserved, eaptypes/eatServerId, eaptypes/eatServiceType, eaptypes/eatSessionId, eaptypes/eatSessionTimeout, eaptypes/eatSignature, eaptypes/eatState, eaptypes/eatTerminationAction, eaptypes/eatTunnelClientEndpoint, eaptypes/eatTunnelMediumType, eaptypes/eatTunnelServerEndpoint, eaptypes/eatTunnelType, eaptypes/eatUnassigned17, eaptypes/eatUnassigned21, eaptypes/eatUserName, eaptypes/eatUserPassword, eaptypes/eatVendorSpecific, eatARAPChallengeResponse, eatARAPFeatures, eatARAPGuestLogon, eatARAPPassword, eatARAPSecurity, eatARAPSecurityData, eatARAPZoneAccess, eatAcctAuthentic, eatAcctDelayTime, eatAcctEventTimeStamp, eatAcctInputOctets, eatAcctInputPackets, eatAcctInterimInterval, eatAcctLinkCount, eatAcctMultiSessionId, eatAcctOutputOctets, eatAcctOutputPackets, eatAcctSessionId, eatAcctSessionTime, eatAcctStatusType, eatAcctTerminateCause, eatCallbackId, eatCallbackNumber, eatCalledStationId, eatCallingStationId, eatCertificateOID, eatClass, eatClearTextPassword, eatConfigurationToken, eatConnectInfo, eatCredentialsChanged, eatEAPConfiguration, eatEAPMessage, eatEAPTLV, eatEMSK, eatFilterId, eatFramedAppleTalkLink, eatFramedAppleTalkNetwork, eatFramedAppleTalkZone, eatFramedCompression, eatFramedIPAddress, eatFramedIPNetmask, eatFramedIPXNetwork, eatFramedIPv6Pool, eatFramedIPv6Prefix, eatFramedIPv6Route, eatFramedInterfaceId, eatFramedMTU, eatFramedProtocol, eatFramedRoute, eatFramedRouting, eatIdleTimeout, eatInnerEapMethodType, eatLoginIPHost, eatLoginIPv6Host, eatLoginLATGroup, eatLoginLATNode, eatLoginLATPort, eatLoginLATService, eatLoginService, eatLoginTCPPort, eatMD5CHAPChallenge, eatMD5CHAPPassword, eatMethodId, eatMinimum, eatNASIPAddress, eatNASIPv6Address, eatNASIdentifier, eatNASPortType, eatNASport, eatPEAPEmbeddedEAPTypeId, eatPEAPFastRoamedSession, eatPasswordRetry, eatPeerId, eatPortLimit, eatPrompt, eatProxyState, eatQuarantineSoH, eatReplyMessage, eatReserved, eatServerId, eatServiceType, eatSessionId, eatSessionTimeout, eatSignature, eatState, eatTerminationAction, eatTunnelClientEndpoint, eatTunnelMediumType, eatTunnelServerEndpoint, eatTunnelType, eatUnassigned17, eatUnassigned21, eatUserName, eatUserPassword, eatVendorSpecific
f1_keywords:
- eaptypes/EAP_ATTRIBUTE_TYPE
dev_langs:
- c++
req.header: eaptypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- eaptypes.h
api_name:
- EAP_ATTRIBUTE_TYPE
targetos: Windows
req.typenames: EAP_ATTRIBUTE_TYPE, EapAttributeType
req.redist: 
ms.custom: 19H1
---

# EAP_ATTRIBUTE_TYPE enumeration


## -description


 The <b>EAP_ATTRIBUTE_TYPE</b> enumeration defines the set of possible EAP attribute types available on an authenticating entity.

Further details for values in this enumerated type are obtained by referring to one of the following references: 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>, <a href="Http://go.microsoft.com/fwlink/p/?linkid=84058">RFC 2868</a>, <a href="Http://go.microsoft.com/fwlink/p/?linkid=84060">RFC 3162</a>, <a href="Http://go.microsoft.com/fwlink/p/?linkid=84061">RFC 3579</a>, or <a href="Http://go.microsoft.com/fwlink/p/?linkid=84062">RFC 3580</a>.


## -enum-fields




### -field eatMinimum

Specifies a value equal to zero, and used as the <b>NULL</b> terminator in any array of 
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> structures. 

This attribute type is consumed by PPP client supplicants.


### -field eatUserName

Specifies the name of the user to be authenticated. This attribute type is also used when the user's password is changed. For Routing and Remote Access Service (RRAS) authentication sessions, the identity string (name) of the authenticating user is sent to IAS as part of the request attributes. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a multi-byte string with no NULL termination character. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is exported  by MS-CHAPv2 methods and by PEAP methods. It is consumed by PPP server supplicants.


### -field eatUserPassword

Specifies the password of the user to be authenticated. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatMD5CHAPPassword

Specifies the password provided by the user in response to an MD5 Challenge Handshake Authentication Protocol (CHAP) challenge. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatNASIPAddress

Specifies the IP address of the Network Access Server (NAS) that is requesting user authentication. An Access-Request should specify either an NAS IP address or an NAS identifier. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatNASPort


### -field eatServiceType

Specifies the type of service the user has requested or the type of service to be provided. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedProtocol

Specifies the type of framed protocol to use for framed access, for example SLIP, PPP, or ARAP (AppleTalk Remote Access Protocol). The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedIPAddress

Specifies the IP address that is configured for the user requesting authentication. This attribute is typically returned by the authentication provider. However, the NAS may use it in an authentication request to specify a preferred IP address. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedIPNetmask

Specifies the IP network mask for a user that is a router to a network. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFramedRouting

Specifies the routing method for a user that is a router to a network. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFilterId

Specifies the name of the filter list for the user requesting authentication. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedMTU

Specifies the Maximum Transmission Unit (MTU) for the user. This attribute is used in cases where the MTU is not negotiated through some other means, such as PPP. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedCompression

Specifies a compression protocol to use for the connection. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatLoginIPHost

Specifies the system with which to connect the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatLoginService

Specifies the service to use to connect the user to the host specified by <b>eatLoginIPHost</b>. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatLoginTCPPort

Specifies the port to which to connect the user. This attribute is present only if the <b>eatLoginService</b> attribute is present. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatUnassigned17

This value is currently unassigned.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatReplyMessage

Specifies a message to display to the user. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type consumed by the PPP server supplicant. This attribute type should not be used by any other method or supplicant. <b>eatEAPMessage</b> should be used to sent displayable messages whenever possible. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84062">RFC 3580</a>.


### -field eatCallbackNumber

Specifies a callback number. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatCallbackId

Specifies a location to call back. The value of this attribute is interpreted by the NAS. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatUnassigned21

This value is currently unassigned.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFramedRoute

Specifies routing information to configure on the NAS for the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>. 

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFramedIPXNetwork

Specifies the IPX network number to configure for the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>. 

This attribute type is not used by EAPHost methods or supplicants.


### -field eatState

Specifies state information provided to the client by the server. For RRAS authentication sessions, if authentication completed successfully and IAS returned attributes, then this state information is saved and used as input when constructing the request attributes for IAS during the next packet cycle.  The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. Refer to 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a> for detailed information about this value. 

This attribute type is consumed by PPP server supplicants.


### -field eatClass

Specifies a value that is provided to the NAS by the authentication provider. The NAS should use this value when communicating with the accounting provider. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatVendorSpecific

Specifies a field for vendor-supplied extended attributes. 

This field is used to store Microsoft Point-to-Point Encryption (MPPE) keys consumed by the <a href="Http://go.microsoft.com/fwlink/p/?linkid=83938">802.1X</a> supplicant. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

The following table shows the structure of the data pointed to by the <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type. 

<table>
<tr>
<th>First Byte</th>
<th>Last Byte </th>
<th>Description</th>
</tr>
<tr>
<td>0</td>
<td>3</td>
<td>Length: 4 bytesThe vendor identifier. This field always has a value of 311.

</td>
</tr>
<tr>
<td>4</td>
<td>4</td>
<td>Length: 1 byteThe type of MPPE key. If the attribute refers to a MPPE send key, then this field has a value of 16. If the attribute refers to a MPPE receive key, then this field has a value of 17. 

</td>
</tr>
<tr>
<td>5</td>
<td>5</td>
<td>Length: 1 byteThe MPPE vendor-specific attribute length. This field always has a value of 52.

</td>
</tr>
<tr>
<td>6</td>
<td>7</td>
<td>Length: 2 bytesSalt. This field always has a value of 0.

</td>
</tr>
<tr>
<td>8</td>
<td>8</td>
<td>Length: 1 byteThe MPPE key length. This field always has a value of 32.

</td>
</tr>
<tr>
<td>9</td>
<td>40</td>
<td>Length: 32 bytesThe MPPE key. The field contents are as follows:<ul>
<li>For MPPE send keys   used on a client, this field contains the first 32 bytes (bytes 0-31) of the master session key (MSK). </li>
<li>For MPPE send keys used on a server, this field contains the second 32 bytes (bytes 32-63) of the MSK.</li>
<li>For MPPE receive keys   used on a client, this field contains the second 32 bytes (bytes 32-63) of the MSK. </li>
<li>For MPPE receive keys used on a server, this field contains the first 32 bytes (bytes 0-31) of the MSK.</li>
</ul>


</td>
</tr>
<tr>
<td>41</td>
<td>55</td>
<td>Length: 15 bytesPadding.

</td>
</tr>
</table>
 

This attribute type is consumed by 802.1X supplicants.


### -field eatSessionTimeout

Specifies the maximum number of seconds for which to provide service to the user. After this time, the session is terminated.  The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is typically used by EAP methods to set the timeout duration for authentication within an Access-Challenge packet. The duration of the timeout is determined by IAS, not the EAP method. 

For RRAS authentication sessions, if authentication succeeded and there is a pending packet to be sent, the packet is sent with an interactive timeout if the corresponding <b>eatSessionTimeout</b> value is greater than 10.

This attribute type is consumed by PPP server supplicants.


### -field eatIdleTimeout

Specifies the maximum number of consecutive seconds the session can be idle. If the idle time exceeds this value, the session is terminated. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>. 

This attribute type is not used by EAPHost methods or supplicants.


### -field eatTerminationAction

Specifies an action the server performs when time the connection terminates. Refer to the above-referenced files for detailed information about this value. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatCalledStationId

Specifies the phone number called using Dialed Number Identification (DNIS) or similar technology. The phone number called by the user may be different than the phone number from which the call originated. This attribute type may also be used to store other types of information, such as MAC addresses. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84062">RFC 3580</a>.


### -field eatCallingStationId

Specifies the originating phone number for a call, using Automatic Number Identification (ANI) or similar technology. This attribute type may also be used to store other types of information, such as MAC addresses. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84062">RFC 3580</a>.


### -field eatNASIdentifier

Specifies the NAS identifier. An Access-Request should specify either an NAS identifier or an NAS IP address. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatProxyState

Specifies a value that a proxy server includes when forwarding an authentication request. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatLoginLATService

Not used. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatLoginLATNode

Not used. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatLoginLATGroup

Not used. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatFramedAppleTalkLink

Specifies the AppleTalk network number for the user when the user is another router. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFramedAppleTalkNetwork

Specifies the AppleTalk network number that the NAS should use to allocate an AppleTalk node for the user. This attribute is used only when the user is not another router. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatFramedAppleTalkZone

Specifies the AppleTalk default zone for the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctStatusType

Specifies whether the accounting provider should start or stop accounting for the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctDelayTime

Specifies the length of time that the client has been attempting to send the current request. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctInputOctets

Specifies the number of octets that have been received during the current accounting session. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctOutputOctets

Specifies the number of octets that were sent during the current accounting session. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctSessionId

Specifies a value to enable the identification of matching start and stop records within a log file. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctAuthentic

Specifies, to the accounting provider, how the user was authenticated; for example by Directory Services, RADIUS, or some other authentication provider. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctSessionTime

Specifies the number of seconds that have elapsed in the current accounting session. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctInputPackets

Specifies the number of packets that have been received during the current accounting session. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctOutputPackets

Specifies the number of packets that have been sent during the current accounting session.  For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctTerminateCause

Specifies how the current accounting session was terminated. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctMultiSessionId

Specifies a value to enable the identification of related accounting sessions within a log file. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctLinkCount

Specifies the number of links if the current accounting session is using a multilink connection. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84056">RFC 2866</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctEventTimeStamp

Specifies an attribute that is included in an accounting request packet. It specifies the time that the event took place. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatMD5CHAPChallenge

Specifies the CHAP challenge sent by the NAS to a CHAP user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatNASPortType

Specifies the type of the port through which NAS is authenticating the user, for example, asynchronous, ISDN, virtual. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatPortLimit

Specifies the number of ports the NAS should make available to the user for multilink sessions. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatLoginLATPort

Not used. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


### -field eatTunnelType

Specifies the tunneling protocol used. 

This attribute type is not used by EAPHost methods or supplicants.


### -field eatTunnelMediumType

Specifies which transport medium to use when creating a tunnel for those protocols (such as L2TP) that can operate over multiple transports. 

This attribute type is not used by EAPHost methods or supplicants.


### -field eatTunnelClientEndpoint

Points to the address of the initiator end of the tunnel.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatTunnelServerEndpoint

Points to the address of the server end of the tunnel.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPPassword

Specifies a password to use for AppleTalk Remote Access Protocol (ARAP) authentication. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPFeatures

Specifies information that an NAS should send back to the user in an ARAP "feature flags" packet. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPZoneAccess

Specifies how to use the ARAP zone list for the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPSecurity

Specifies an ARAP security module to use during a secondary authentication phase between the NAS and the user. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPSecurityData

Specifies the data to use with an ARAP security module. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatPasswordRetry

Specifies the number of password retry attempts to permit the user access. This attribute type is deprecated for EAP and RADIUS/EAP. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84061">RFC 3579</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatPrompt

Specifies whether the NAS should echo the user response to a challenge. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatConnectInfo

Specifies information about the type of connection the user is using. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatConfigurationToken

Specifies user-profile information in communications between RADIUS Proxy Servers and RADIUS Proxy Clients. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatEAPMessage

Specifies that EAP information be sent directly between the user and the authentication provider. For RRAS authentication sessions, this attribute type is used to retrieve the EAP message from the authenticator and send the message to the  client. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is consumed by PPP server supplicants.


### -field eatSignature

Specifies a signature to include with CHAP, EAP, or ARAP packets. For more information, 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatARAPChallengeResponse

Specifies the response to a Apple Remote Access Protocol (ARAP) challenge. In ARAP, either the server or the client may respond to challenges. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatAcctInterimInterval

Specifies the time, in seconds, between accounting updates. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatNASIPv6Address

The IPv6 address of the NAS requesting user authentication. This address should be unique to the NAS within the scope of the RADIUS server. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84060">RFC 3162</a>.


### -field eatFramedInterfaceId

The IPv6 interface identifier to be configured for the user. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84060">RFC 3162</a>.


### -field eatFramedIPv6Prefix

The IPv6 prefix (and corresponding route) to be configured for the user. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see <a href="Http://go.microsoft.com/fwlink/p/?linkid=84060">RFC 3162</a>.


### -field eatLoginIPv6Host

Not used.


### -field eatFramedIPv6Route

Not used.


### -field eatFramedIPv6Pool

Not used.


### -field eatARAPGuestLogon

Specifies a Apple Remote Access Protocol (ARAP) guest logon. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84059">RFC 2869</a>.

This attribute type is not used by EAPHost methods or supplicants.


### -field eatCertificateOID

The object identifier (OID) present on the certificate. This attribute type is used in certificate-based authentication sessions. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string.  

This attribute type is exported  by EAP-TLS and NPS methods.


### -field eatEAPConfiguration

Not used.


### -field eatPEAPEmbeddedEAPTypeId

The identifier of the inner EAP method used in PEAP authentication.  The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a DWORD.  Only the least significant byte of the DWORD is meaningful. 

This attribute type is exported  by PEAP methods and is not consumed by any supplicant.


### -field eatPEAPFastRoamedSession

Specifies whether PEAP fast reconnect is used by the authenticator.  The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a DWORD.  If  <b>pValue</b> points to 0, then fast reconnect is not used by the authenticator. If <b>pValue</b> points to a nonzero value, then fast reconnect is used by the authenticator.

This attribute type is exported  by PEAP methods and consumed by PPP client supplicants.


### -field eatFastRoamedSession


### -field eatEAPTLV

An EAP-TLV attribute. This attribute type is used to handle statement of health (SoH) requests and SoH responses from the server. 

The following table shows the structure of the data pointed to by the <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type. 

<table>
<tr>
<th>First Byte</th>
<th>Last Byte </th>
<th>Description</th>
</tr>
<tr>
<td>0</td>
<td>1</td>
<td>Length: 2 bytesThe buffer type. This field always has a value of 7. 

</td>
</tr>
<tr>
<td>2</td>
<td>3</td>
<td>Length: 2 bytesThe length of the remaining contents of the buffer. For SoH requests from the server, this field has a value of 6. For SoH responses from the server, calculate the length by adding 8 to the number of bytes in the SoH payload.

</td>
</tr>
<tr>
<td>4</td>
<td>7</td>
<td>Length: 4 bytesThe vendor identifier. This field always has a value of 311.

</td>
</tr>
<tr>
<td>8</td>
<td>9</td>
<td>Length: 2 bytesThe SoH type. For SoH requests from the server, this field has a value of 2. For SoH responses from the server, this field has a value of 3. 

</td>
</tr>
<tr>
<td>10</td>
<td>11</td>
<td>Length: 2 bytesThe number of bytes of data in the SoH payload.

</td>
</tr>
<tr>
<td>12</td>
<td></td>
<td>Length: VariableThe SoH payload returned by the NAP system. The supplicant should not attempt to interpret this data.

</td>
</tr>
</table>
 

This attribute type is consumed by PPP client supplicants and by EAPHost supplicants.


### -field eatCredentialsChanged

Specifies whether credentials have changed during EAP authentication. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a DWORD.  If  <b>pValue</b> points to 0, then the credentials have not changed. If <b>pValue</b> points to a nonzero value, then credentials have changed.

This attribute type may be exported by MS-CHAPv2 methods, and is consumed by PPP client supplicants.


### -field eatInnerEapMethodType

The inner EAP method used inside native tunnel methods. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_type">EAP_METHOD_TYPE</a> structure. 

This attribute type is exported by EAP methods.


### -field eatClearTextPassword

The password, in clear text, of the user to be authenticated. This attribute type is sent by EAP methods that use EAPHost to raise the identity user interface. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to an <a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_type">EAP_METHOD_TYPE</a> structure. 

This attribute type is exported by EAPHost.


### -field eatQuarantineSoH

Contains SoH request and response information used during EAP authentication.  The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string.  

This attribute type is exported by EAPHost and PEAP methods, and consumed by PPP server supplicants.


### -field eatCertificateThumbprint


### -field eatPeerId

The peer identity provided in the identity response message (EAP-Response/Identity). This identity may be different than the peer identity authenticated by the EAP method.   The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to an ASCII string. The string will be <b>NULL</b> if the EAP peer identity does not exist. For more information, see the <a href="Http://go.microsoft.com/fwlink/p/?linkid=84023">Key Management Framework draft specification</a>. 

This attribute type is exported by EAP methods and consumed by supplicants.


### -field eatServerId

The identity of the server used when the EAP method authenticates to the server. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to an ASCII string. The string will be <b>NULL</b> if an EAP method does not define a method-specific peer identity. For more information, see the <a href="Http://go.microsoft.com/fwlink/p/?linkid=84023">Key Management Framework draft specification</a>. 

This attribute type is exported by EAP methods and consumed by supplicants.


### -field eatMethodId

A temporally unique method identifier that identifies an EAP session of a given type between an peer and a server. Any EAP method that derives keys must specify this attribute type. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a DWORD. For more information, see the <a href="Http://go.microsoft.com/fwlink/p/?linkid=84023">Key Management Framework draft specification</a>. 

This attribute type is exported by EAPHost methods and other EAP methods, and consumed by supplicants.


### -field eatEMSK

The extended session master key (EMSK). This key material is derived  between the peer and the server, and should not be shared with a third party. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string, which should contain at least 64 octets of key material. For more information, see the <a href="Http://go.microsoft.com/fwlink/p/?linkid=84023">Key Management Framework draft specification</a>. 

This attribute type is exported by EAP methods and consumed by supplicants.


### -field eatSessionId

Windows Vista with SP1 or later: An attribute type which carries the session identity


### -field eatReserved

Not used.


### -field v1_enum




#### - eatNASport

Specifies the physical or virtual private network (VPN) through which the user is connecting to the NAS. Note that this value is not a port number in the sense of TCP or UDP. The <b>pValue</b> member  of  
<a href="https://docs.microsoft.com/windows/desktop/api/eaptypes/ns-eaptypes-eap_attribute">EAP_ATTRIBUTE</a> for this type points to a byte string. For more information, see 
<a href="Http://go.microsoft.com/fwlink/p/?linkid=84055">RFC 2865</a>.


## -see-also




[About EAP Attributes](https://docs.microsoft.com/windows/win32/eaphost/about-eap-attributes)a>



<a href="Http://go.microsoft.com/fwlink/p/?linkid=84002">PEAP</a>
 

 

