---
UID: NS:eaptypes._EAP_METHOD_PROPERTY_VALUE_BOOL
title: EAP_METHOD_PROPERTY_VALUE_BOOL (eaptypes.h)
description: Contains a Boolean value of an EAP method property.
old-location: eaphost\eap_method_property_value_bool.htm
tech.root: eaphost
ms.assetid: ff482df6-a9c9-41b3-bedf-880fee71b968
ms.date: 12/05/2018
ms.keywords: EAP_METHOD_PROPERTY_VALUE_BOOL, EAP_METHOD_PROPERTY_VALUE_BOOL structure [EAPHost], PEAP_METHOD_PROPERTY_VALUE_BOOL, PEAP_METHOD_PROPERTY_VALUE_BOOL structure pointer [EAPHost], eaphost.eap_method_property_value_bool, eaptypes/EAP_METHOD_PROPERTY_VALUE_BOOL, eaptypes/PEAP_METHOD_PROPERTY_VALUE_BOOL
f1_keywords:
- eaptypes/EAP_METHOD_PROPERTY_VALUE_BOOL
dev_langs:
- c++
req.header: eaptypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- EapTypes.h
api_name:
- EAP_METHOD_PROPERTY_VALUE_BOOL
targetos: Windows
req.typenames: EAP_METHOD_PROPERTY_VALUE_BOOL
req.redist: 
ms.custom: 19H1
---

# EAP_METHOD_PROPERTY_VALUE_BOOL structure


## -description


The <b>EAP_METHOD_PROPERTY_VALUE_BOOL</b> structure contains a Boolean value of an EAP method property.


## -struct-fields




### -field length

The size, in bytes, of <b>value</b>.


### -field value

<b>BOOL</b> value of the method property.


## -see-also




[EAPHost Supplicant Structures](https://docs.microsoft.com/windows/win32/eaphost/eap-host-supplicant-structures)a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_property_value">EAP_METHOD_PROPERTY_VALUE</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeergetmethodproperties">EapHostPeerGetMethodProperties</a>
 

 

