---
UID: NS:eaptypes._EAP_METHOD_PROPERTY_VALUE_DWORD
title: EAP_METHOD_PROPERTY_VALUE_DWORD (eaptypes.h)
description: Contains the DWORD value of an EAP method property.
old-location: eaphost\eap_method_property_value_dword.htm
tech.root: eaphost
ms.assetid: 79a1ff42-dfd9-4408-b96c-2fbc33c2ca93
ms.date: 12/05/2018
ms.keywords: EAP_METHOD_PROPERTY_VALUE_DWORD, EAP_METHOD_PROPERTY_VALUE_DWORD structure [EAPHost], PEAP_METHOD_PROPERTY_VALUE_DWORD, PEAP_METHOD_PROPERTY_VALUE_DWORD structure pointer [EAPHost], eaphost.eap_method_property_value_dword, eaptypes/EAP_METHOD_PROPERTY_VALUE_DWORD, eaptypes/PEAP_METHOD_PROPERTY_VALUE_DWORD
f1_keywords:
- eaptypes/EAP_METHOD_PROPERTY_VALUE_DWORD
dev_langs:
- c++
req.header: eaptypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7 [desktop apps only]
req.target-min-winversvr: Windows Server 2008 R2 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- EapTypes.h
api_name:
- EAP_METHOD_PROPERTY_VALUE_DWORD
targetos: Windows
req.typenames: EAP_METHOD_PROPERTY_VALUE_DWORD
req.redist: 
ms.custom: 19H1
---

# EAP_METHOD_PROPERTY_VALUE_DWORD structure


## -description


The <b>EAP_METHOD_PROPERTY_VALUE_DWORD</b> structure contains the DWORD value of an EAP method property.


## -struct-fields




### -field length

The size, in bytes, of <b>value</b>. 


### -field value

A DWORD value of the method property.


## -see-also




[EAPHost Supplicant Structures](https://docs.microsoft.com/windows/win32/eaphost/eap-host-supplicant-structures)a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaptypes/ns-eaptypes-eap_method_property_value">EAP_METHOD_PROPERTY_VALUE</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/eaphostpeerconfigapis/nf-eaphostpeerconfigapis-eaphostpeergetmethodproperties">EapHostPeerGetMethodProperties</a>
 

 

