---
UID: NE:exdisp.ShellWindowTypeConstants
title: ShellWindowTypeConstants (exdisp.h)
description: Specifies types of Shell windows.
old-location: shell\ShellWindowTypeConstants.htm
tech.root: shell
ms.assetid: 79d4fcf3-5256-4e21-ab9a-94605e1d742f
ms.date: 12/05/2018
ms.keywords: SWC_3RDPARTY, SWC_BROWSER, SWC_CALLBACK, SWC_DESKTOP, SWC_EXPLORER, ShellWindowTypeConstants, ShellWindowTypeConstants enumeration [Windows Shell], _win32_ShellWindowTypeConstants, exdisp/SWC_3RDPARTY, exdisp/SWC_BROWSER, exdisp/SWC_CALLBACK, exdisp/SWC_DESKTOP, exdisp/SWC_EXPLORER, exdisp/ShellWindowTypeConstants, shell.ShellWindowTypeConstants
f1_keywords:
- exdisp/ShellWindowTypeConstants
dev_langs:
- c++
req.header: exdisp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Exdisp.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Exdisp.h
api_name:
- ShellWindowTypeConstants
targetos: Windows
req.typenames: ShellWindowTypeConstants
req.redist: 
req.product: Internet Explorer 5
ms.custom: 19H1
---

# ShellWindowTypeConstants enumeration


## -description


Specifies types of Shell windows.


## -enum-fields




### -field SWC_EXPLORER

An Windows Explorer (Explorer.exe) window.


### -field SWC_BROWSER

An Internet Explorer (Iexplore.exe) browser window.


### -field SWC_3RDPARTY

A non-Microsoft browser window.


### -field SWC_CALLBACK

A creation callback window.


### -field SWC_DESKTOP

<b>Windows Vista and later</b>. The Windows desktop.


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/shdeprecated/nf-shdeprecated-ibrowserservice-registerwindow">IBrowserService::RegisterWindow</a>



<a href="https://docs.microsoft.com/windows/desktop/api/exdisp/nn-exdisp-ishellwindows">IShellWindows</a>



<a href="https://docs.microsoft.com/windows/desktop/api/exdisp/nf-exdisp-ishellwindows-findwindowsw">IShellWindows::FindWindowSW</a>



<a href="https://docs.microsoft.com/windows/desktop/api/exdisp/nf-exdisp-ishellwindows-register">IShellWindows::Register</a>



<a href="https://docs.microsoft.com/windows/desktop/api/exdisp/nf-exdisp-ishellwindows-registerpending">IShellWindows::RegisterPending</a>
 

 

