---
UID: NF:faxcom.IFaxServer.get_Branding
title: IFaxServer::get_Branding (faxcom.h)
description: Sets or retrieves the Branding property for a FaxServer object. The Branding property is a Boolean value that indicates whether the fax server generates branding information at the top of fax transmissions.
old-location: fax\_mfax_ifaxserver_client_mfax_ifaxserver_get_branding_cpp.htm
tech.root: Fax
ms.assetid: VS|fax|~\fax\faxlegacy_1v1j.htm
ms.date: 12/05/2018
ms.keywords: Branding property [Fax Service], Branding property [Fax Service],IFaxServer interface, IFaxServer interface [Fax Service],Branding property, IFaxServer.Branding, IFaxServer.get_Branding, IFaxServer.put_Branding, IFaxServer::Branding, IFaxServer::get_Branding, IFaxServer::put_Branding, _mfax_ifaxserver_get_branding, fax._mfax_ifaxserver_client_mfax_ifaxserver_get_branding_cpp, fax._mfax_ifaxserver_get_branding, faxcom/IFaxServer::Branding, faxcom/IFaxServer::get_Branding, faxcom/IFaxServer::put_Branding, get_Branding
f1_keywords:
- faxcom/IFaxServer.Branding
dev_langs:
- c++
req.header: faxcom.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Faxcom.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Faxcom.dll
api_name:
- IFaxServer.Branding
- IFaxServer.get_Branding
- IFaxServer.put_Branding
- IFaxServer.get_Branding
- IFaxServer.put_Branding
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFaxServer::get_Branding


## -description


Sets or retrieves the <b>Branding</b> property for a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-faxserver-client">FaxServer</a> object. The <b>Branding</b> property is a Boolean value that indicates whether the fax server generates branding information at the top of fax transmissions.

This property is read/write.


## -parameters


## -remarks



A brand is an informational header at the top of most fax pages that typically contains the transmission time, the page count, and the transmitting station identifier. Branding may be required by law in some locales.
		




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-fax-service-client-api-interfaces">Fax Service Client API Interfaces</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-fax-service-client-api-for-windows-2000">Fax Service Client API for Windows 2000</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-faxserver-client">FaxServer</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxcom/nn-faxcom-ifaxserver">IFaxServer</a>
 

 

