---
UID: NF:faxext.FaxExtRegisterForEvents
title: FaxExtRegisterForEvents function (faxext.h)
description: The FaxExtRegisterForEvents callback function registers the fax extension DLL for notifications about configuration data changes related to a specific device and GUID.
old-location: fax\_mfax_faxextregisterforevents.htm
tech.root: Fax
ms.assetid: VS|fax|~\fax\faxextconfigref_9ysz.htm
ms.date: 12/05/2018
ms.keywords: DEV_ID_SRC_FAX, DEV_ID_SRC_TAPI, FaxExtRegisterForEvents, FaxExtRegisterForEvents function [Fax Service], _mfax_faxextregisterforevents, fax._mfax_faxextregisterforevents, faxext/FaxExtRegisterForEvents
f1_keywords:
- faxext/FaxExtRegisterForEvents
dev_langs:
- c++
req.header: faxext.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- FaxExt.h
api_name:
- FaxExtRegisterForEvents
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# FaxExtRegisterForEvents function


## -description


The <b>FaxExtRegisterForEvents</b> callback function registers the fax extension DLL for notifications about configuration data changes related to a specific device and GUID.


## -parameters




### -param hInst [in]

Type: <b>HINSTANCE</b>

Specifies an <b>HINSTANCE</b> value that identifies the fax extension DLL instance that is requesting notifications. The fax service uses this value to prevent sending notifications about data changes to the same extension that changed the data.


### -param dwDeviceId [in]

Type: <b>DWORD</b>

Specifies a <b>DWORD</b> value that indicates the device for which notifications should be sent.




This parameter can be zero, indicating that the fax service should send notifications about changes to global configuration data, which is configuration data that is not associated with a specific device. For more information, see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-storing-global-configuration-data">Storing Global Configuration Data</a>.


### -param DevIdSrc [in]

Type: <b>FAX_ENUM_DEVICE_ID_SOURCE</b>

Specifies the source of the <i>dwDeviceId</i> parameter. This parameter can have one of the following values.



#### DEV_ID_SRC_FAX (DEV_ID_SRC_FAX)

The <i>dwDeviceId</i> parameter is generated by the fax service or by a virtual FSP. Fax routing extensions and virtual FSPs should use this value.



#### DEV_ID_SRC_TAPI (DEV_ID_SRC_TAPI)

The <i>dwDeviceId</i> parameter is generated by a TAPI TSP. FSPs that are TAPI-based should use this value.


### -param lpcwstrDataGUID [in]

Type: <b>LPCWSTR</b>

Pointer to a constant null-terminated Unicode character string that specifies the GUID of the data for which notifications should be sent; for example, "{b8959fc9-4e77-4ee9-8411-009acb1bbf3e}". 


### -param lpConfigChangeCallback [in]

Type: <b>LPBYTE</b>

Pointer to a <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextconfigchange">FaxExtConfigChange</a> callback function defined in the fax extension DLL. The fax service calls this function to notify the fax extension about configuration data changes.


## -returns



Type: <b>HANDLE</b>

If the function succeeds, the return value is a notification <b>HANDLE</b>.




If the function fails, the return value is <b>NULL</b>. To get extended error information, call GetLastError.




The <b>FaxExtRegisterForEvents</b> function can return the following error codes.


<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
</dl>
</td>
<td width="60%">
At least one parameter passed to the function is invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_BUSY</b></dt>
</dl>
</td>
<td width="60%">
The server cannot process a request for notifications while it is sending a notification about a data change. You should try calling the function at a later time.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_ALREADY_ASSIGNED</b></dt>
</dl>
</td>
<td width="60%">
The extension has already requested notifications about configuration data changes to this device ID and GUID.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NOT_ENOUGH_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
Not enough memory is available to complete the operation.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_GEN_FAILURE</b></dt>
</dl>
</td>
<td width="60%">
An internal failure at the fax server prevents access to the data.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_SHUTDOWN_IN_PROGRESS</b></dt>
</dl>
</td>
<td width="60%">
The server is shutting down.

</td>
</tr>
</table>
 




## -remarks



When the fax extension calls this fax service callback function, it must use the function pointer exposed by the fax service when the service calls the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a> function. 

<b>Security requirements:</b> The caller must have access rights to query a server's configuration in order to call this function.

If an extension registers to receive notifications about configuration data changes, the extension does not receive notifications about new configuration values that it sets itself.

A fax extension can register to receive notifications about data changes that occur for device IDs and GUIDs that will exist at a later time. Once the device ID and GUID receive data, the fax service issues the change notification. It is also possible to store configuration data (that is, call the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextsetdata">FaxExtSetData</a> function) for devices that do not yet exist.

The fax service passes a pointer to the <b>FaxExtRegisterForEvents</b> callback function when the fax service calls the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a> function. The PFAX_EXT_REGISTER_FOR_EVENTS data type is a pointer to a <b>FaxExtRegisterForEvents</b> function.

The <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextunregisterforevents">FaxExtUnregisterForEvents</a> callback function unregisters the fax extension DLL for notifications about global configuration data changes or configuration data changes related to a specific device and GUID.

Applications can change global configuration data or the data associated with a specific fax device by calling the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextsetdata">FaxExtSetData</a> function.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextconfigchange">FaxExtConfigChange</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextsetdata">FaxExtSetData</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextunregisterforevents">FaxExtUnregisterForEvents</a>
 

 

