---
UID: NF:faxext.FaxExtSetData
title: FaxExtSetData function (faxext.h)
description: The FaxExtSetData function sets configuration data for a specific device and GUID.
old-location: fax\_mfax_faxextsetdata.htm
tech.root: Fax
ms.assetid: VS|fax|~\fax\faxextconfigref_7ba9.htm
ms.date: 12/05/2018
ms.keywords: DEV_ID_SRC_FAX, DEV_ID_SRC_TAPI, FaxExtSetData, FaxExtSetData function [Fax Service], _mfax_faxextsetdata, fax._mfax_faxextsetdata, faxext/FaxExtSetData
f1_keywords:
- faxext/FaxExtSetData
dev_langs:
- c++
req.header: faxext.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP [desktop apps only]
req.target-min-winversvr: Windows Server 2003 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- FaxExt.h
api_name:
- FaxExtSetData
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# FaxExtSetData function


## -description


The <b>FaxExtSetData</b> function sets configuration data for a specific device and GUID.


## -parameters




### -param hInst [in]

Type: <b>HINSTANCE</b>

Specifies an <b>HINSTANCE</b> value that identifies the fax extension DLL instance that is requesting a data change. The fax service uses this value to prevent sending notifications about data changes to the same extension that changed the data.


### -param dwDeviceId [in]

Type: <b>DWORD</b>

Specifies a <b>DWORD</b> value that indicates the device for which data is to be set.




If this parameter is zero, it indicates that the data to set is global configuration data (configuration data that is not associated with a specific device). For example, a fax routing extension may export several different fax routing methods that use OCR technology and rely on the same OCR parameters. The routing extension can specify that the OCR configuration data is global, rather than device-specific, by specifying zero in this parameter. For more information, see <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fax/-mfax-storing-global-configuration-data">Storing Global Configuration Data</a>.


### -param DevIdSrc [in]

Type: <b>FAX_ENUM_DEVICE_ID_SOURCE</b>

Specifies the source of the <i>dwDeviceId</i> parameter. This parameter can have one of the following values.



#### DEV_ID_SRC_FAX (DEV_ID_SRC_FAX)

The <i>dwDeviceId</i> parameter is generated by the fax service or by a virtual FSP. Fax routing extensions and virtual FSPs should use this value.



#### DEV_ID_SRC_TAPI (DEV_ID_SRC_TAPI)

The <i>dwDeviceId</i> parameter is generated by a TAPI TSP. FSPs that are TAPI-based should use this value.


### -param lpcwstrDataGUID [in]

Type: <b>LPCWSTR</b>

Pointer to a constant null-terminated Unicode character string that specifies the GUID of the data to set; for example, "{b8959fc9-4e77-4ee9-8411-009acb1bbf3e}". 


### -param pData [in]

Type: <b>LPBYTE</b>

Pointer to the buffer that contains the configuration data to set.


### -param dwDataSize [in]

Type: <b>DWORD</b>

A <b>DWORD</b> value that indicates the size, in bytes, of the buffer pointed to by the <i>pData</i> parameter.


## -returns



Type: <b>DWORD</b>

If the function succeeds, the return value is <b>ERROR_SUCCESS</b>.





If the function fails, the return value is a nonzero error code defined in WinError.h. You can call the Win32 <b>FormatMessage</b> function specifying the FORMAT_MESSAGE_FROM_SYSTEM flag to retrieve a generic description of the error.





The <b>FaxExtSetData</b> function can return the following error codes.


<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_SUCCESS</b></dt>
</dl>
</td>
<td width="60%">
The configuration data was successfully stored.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_INVALID_PARAMETER</b></dt>
</dl>
</td>
<td width="60%">
At least one parameter passed to the function is invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_NOT_ENOUGH_MEMORY</b></dt>
</dl>
</td>
<td width="60%">
Not enough memory is available to complete the operation.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_FILE_NOT_FOUND</b></dt>
</dl>
</td>
<td width="60%">
A device with the specified device ID was not found.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_GEN_FAILURE</b></dt>
</dl>
</td>
<td width="60%">
An internal failure at the fax server prevents access to the data.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>ERROR_SHUTDOWN_IN_PROGRESS</b></dt>
</dl>
</td>
<td width="60%">
The server is shutting down.

</td>
</tr>
</table>
 




## -remarks



When the fax extension calls this fax service callback function, it must use the function pointer exposed by the fax service when the service calls the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a> function.

<b>Security requirements:</b> The caller must have access rights to manage server configuration data in order to call this function.

You can call the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextgetdata">FaxExtGetData</a> function to retrieve global configuration data or configuration data for a specific device and GUID.

The fax service passes a pointer to the <b>FaxExtSetData</b> callback function when the fax service calls the <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a> function. The PFAX_EXT_SET_DATA data type is a pointer to a <b>FaxExtSetData</b> function.





## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextgetdata">FaxExtGetData</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/faxext/nf-faxext-faxextinitializeconfig">FaxExtInitializeConfig</a>
 

 

