---
UID: NF:frquery.CFrameworkQuery.GetValuesForProp(LPCWSTR,CHStringArray &)
title: CFrameworkQuery::GetValuesForProp(LPCWSTR,CHStringArray &) (frquery.h)
description: The GetValuesForProp method returns all of the values for a particular property that are generated by that property as it appears within the query.
old-location: wmi\cframeworkquery_getvaluesforprop_lpcwstr_chstringarray__.htm
tech.root: WmiSdk
ms.assetid: 94e9d581-d4f6-499a-88bd-eeef1ce5133f
ms.date: 12/05/2018
ms.keywords: ?GetValuesForProp@CFrameworkQuery@@QAEJPBGAAVCHStringArray@@@Z, ?GetValuesForProp@CFrameworkQuery@@QEAAJPEBGAEAVCHStringArray@@@Z, CFrameworkQuery interface [Windows Management Instrumentation],GetValuesForProp method, CFrameworkQuery.GetValuesForProp, CFrameworkQuery.GetValuesForProp(LPCWSTR,CHStringArray &), CFrameworkQuery::GetValuesForProp, CFrameworkQuery::GetValuesForProp(CHStringArray&,LPCWSTR), CFrameworkQuery::GetValuesForProp(LPCWSTR,CHStringArray &), GetValuesForProp, GetValuesForProp method [Windows Management Instrumentation], GetValuesForProp method [Windows Management Instrumentation],CFrameworkQuery interface, frquery/CFrameworkQuery::GetValuesForProp, wmi.cframeworkquery_getvaluesforprop_lpcwstr_chstringarray__
f1_keywords:
- frquery/CFrameworkQuery.GetValuesForProp
dev_langs:
- c++
req.header: frquery.h
req.include-header: FwCommon.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: FrameDyn.lib
req.dll: FrameDynOS.dll; FrameDyn.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FrameDynOS.dll
- FrameDyn.dll
api_name:
- CFrameworkQuery.GetValuesForProp
- ?GetValuesForProp@CFrameworkQuery@@QAEJPBGAAVCHStringArray@@@Z
- ?GetValuesForProp@CFrameworkQuery@@QEAAJPEBGAEAVCHStringArray@@@Z
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CFrameworkQuery::GetValuesForProp(LPCWSTR,CHStringArray &)


## -description


<p class="CCE_Message">[The <a href="https://docs.microsoft.com/windows/desktop/api/frquery/nl-frquery-cframeworkquery">CFrameworkQuery</a> class 
    is part of the WMI Provider Framework which is now considered in final state, and no further development, 
    enhancements, or updates will be available for non-security related issues affecting these libraries. The 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/wmi_v2/windows-management-infrastructure">MI APIs</a> should be used for all new 
    development.]

The <a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getvaluesforprop(lpcwstr_chstringarray_)">GetValuesForProp</a> method returns all of the values for a particular property that are generated by that property as it appears within the query.

For example, a call to <a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getvaluesforprop(lpcwstr_chstringarray_)">GetValuesForProp</a>(L"Name", sa) returns the array <i>sa</i>, which contains all the values of "Name" that require instances to be sent back to satisfy the query. If <i>sa</i> contains {"a","b"}, then all the instances where "Name=a" plus all the instances where "Name=b" must be sent back to completely satisfy the query.

If the constraints on "Name" are not sufficiently limiting, an empty <i>sa</i> array is returned.


## -parameters




### -param wszPropName

Array of values for the property specified by <i>wszPropName</i>.


### -param achNames

Name of the target property.


## -returns



This method returns <b>WBEM_S_NO_ERROR</b> on success, and <b>WBEM_E_FAILED</b>, or any other <b>HRESULT</b> error code, on failure.




## -remarks



Given a property name, this method returns all of the result values in a <a href="https://docs.microsoft.com/windows/desktop/api/chstrarr/nl-chstrarr-chstringarray">CHStringArray</a> or vector container. The vector container holds <b>_bstr_t</b> objects that contain the result values.

For example, the following list lists the values that are returned by <a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getvaluesforprop(lpcwstr_chstringarray_)">GetValuesForProp</a> for a variety of queries when called with <i>wszPropName</i> set to "Drive".

<table>
<tr>
<th>Query</th>
<th>Return value</th>
<th>Result</th>
</tr>
<tr>
<td>

<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">SELECT</a> * FROM<a href="https://docs.microsoft.com/windows/desktop/CIMWin32Prov/win32-directory">Win32_Directory</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">WHERE</a> Drive = "C:"

</td>
<td><b>WBEM_S_NO_ERROR</b></td>
<td>C:</td>
</tr>
<tr>
<td>

<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">SELECT</a> * FROM<a href="https://docs.microsoft.com/windows/desktop/CIMWin32Prov/win32-directory">Win32_Directory</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">WHERE</a> Drive = "C:" OR FileSize = 256

</td>
<td><b>WBEM_S_NO_ERROR</b></td>
<td>No results; <i>aszNames</i> is empty.</td>
</tr>
<tr>
<td>

<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">SELECT</a> * FROM<a href="https://docs.microsoft.com/windows/desktop/CIMWin32Prov/win32-directory">Win32_Directory</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">WHERE</a> Drive = "C:" OR Drive = "D:"

</td>
<td><b>WBEM_S_NO_ERROR</b></td>
<td>C:, D:</td>
</tr>
<tr>
<td>

<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">SELECT</a> * FROM<a href="https://docs.microsoft.com/windows/desktop/CIMWin32Prov/win32-directory">Win32_Directory</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">WHERE</a> Drive &lt;&gt; "C:"

</td>
<td><b>WBEM_S_NO_ERROR</b></td>
<td>No results; <i>aszNames</i> is empty.</td>
</tr>
<tr>
<td>

<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">SELECT</a> * FROM<a href="https://docs.microsoft.com/windows/desktop/CIMWin32Prov/win32-directory">Win32_Directory</a>



<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/select-statement-for-data-queries">WHERE</a>
<a href="https://docs.microsoft.com/windows/desktop/WmiSdk/swbemobjectpath-path">Path</a> = "\DOS"

</td>
<td><b>WBEM_S_NO_ERROR</b></td>
<td>No results; <i>aszNames</i> is empty.</td>
</tr>
</table>
 

The <a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getvaluesforprop(lpcwstr_chstringarray_)">GetValuesForProp</a> method only supports string types. For example, the following query, followed by a call to <b>GetValuesForProp</b>("PropInt", values), returns <b>WBEM_E_INVALID_QUERY</b> while <b>GetValuesForProp</b>("PropStr", values) returns <b>S_OK</b>.


```cpp
SELECT * FROM Test WHERE PropInt = 32 AND PropStr = "a"
```





## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nl-frquery-cframeworkquery">CFrameworkQuery</a>



<a href="https://docs.microsoft.com/windows/desktop/api/provider/nf-provider-provider-execquery">Provider::ExecQuery</a>
 

 

