---
UID: NL:frquery.CFrameworkQuery
title: CFrameworkQuery (frquery.h)
description: The CFrameworkQuery class is used to parse and manipulate a query. It contains methods that return specific property values and methods that test the query to determine the particular properties that are included.
old-location: wmi\cframeworkquery.htm
tech.root: WmiSdk
ms.assetid: 60a7d83c-cfea-41fa-8d97-321127d33c43
ms.date: 12/05/2018
ms.keywords: CFrameworkQuery, CFrameworkQuery class [Windows Management Instrumentation], CFrameworkQuery class [Windows Management Instrumentation],described, _hmm_cframeworkquery, frquery/CFrameworkQuery, wmi.cframeworkquery
f1_keywords:
- frquery/CFrameworkQuery
dev_langs:
- c++
req.header: frquery.h
req.include-header: FwCommon.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: FrameDyn.lib
req.dll: FrameDynOS.dll; FrameDyn.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FrameDynOS.dll
- FrameDyn.dll
api_name:
- CFrameworkQuery
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# CFrameworkQuery class


## -description


<p class="CCE_Message">[The <b>CFrameworkQuery</b> class is 
    part of the WMI Provider Framework and is now considered in final state, and no further development, enhancements, 
    or updates will be available for non-security related issues affecting these libraries. The 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/wmi_v2/windows-management-infrastructure">MI APIs</a> should be used for all new 
    development.]

The <b>CFrameworkQuery</b> class is used to parse and 
    manipulate a query. It contains methods that return specific property values and methods that test the query to 
    determine the particular properties that are included.

Provider writers will generally not need to create any derived classes from this class, or to create any 
    instances of this class. More commonly, you will be passed an instance of this class and will use the various 
    methods to determine what information is being requested by the client.

<b xmlns:loc="http://microsoft.com/wdcml/l10n">CFrameworkQuery</b> has these types of members:
<ul>
<li><a href="https://docs.microsoft.com/">Methods</a></li>
</ul><h3><a id="methods"></a>Methods</h3>The <b>CFrameworkQuery</b> class has these methods.
<table class="members" id="memberListMethods">
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-allpropertiesarerequired">AllPropertiesAreRequired</a>
</td>
<td align="left" width="63%">
Indicates whether all of the properties for the instance are being requested.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getquery">GetQuery</a>
</td>
<td align="left" width="63%">
Retrieves the actual WQL command associated with the 
     <b>CFrameworkQuery</b> object.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getqueryclassname">GetQueryClassName</a>
</td>
<td align="left" width="63%">
Retrieves the class name from the query.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getrequiredproperties">GetRequiredProperties</a>
</td>
<td align="left" width="63%">
Returns a list of all of the properties required to satisfy a query. It includes the properties from both 
     the <b>SELECT</b> and <b>WHERE</b> clauses.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-getvaluesforprop(lpcwstr_chstringarray_)">GetValuesForProp</a>
</td>
<td align="left" width="63%">
Returns all of the values for a particular property that are generated by that property as it appears within 
     the query.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-ispropertyrequired">IsPropertyRequired</a>
</td>
<td align="left" width="63%">
Determines if a particular property was requested by the query. Both the 
     <b>SELECT</b> and <b>WHERE</b> clauses are checked.

</td>
</tr>
<tr data="declared;">
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/frquery/nf-frquery-cframeworkquery-keysonly">KeysOnly</a>
</td>
<td align="left" width="63%">
Indicates whether only the key properties are required.

</td>
</tr>
</table> 


## -remarks



The destructor for this class is <b>CFrameworkQuery::~CFrameworkQuery</b>.



