---
UID: NF:fsrm.IFsrmActionCommand.put_Arguments
title: IFsrmActionCommand::put_Arguments (fsrm.h)
description: Retrieves or sets the arguments to pass to the executable program specified in the ExecutablePath property.
old-location: fsrm\ifsrmactioncommand_arguments.htm
tech.root: fsrm
ms.assetid: 2ffc8753-3a63-4619-936d-f2f4d2362508
ms.date: 12/05/2018
ms.keywords: Arguments property [File Server Resource Manager], Arguments property [File Server Resource Manager],IFsrmActionCommand interface, IFsrmActionCommand interface [File Server Resource Manager],Arguments property, IFsrmActionCommand.Arguments, IFsrmActionCommand.put_Arguments, IFsrmActionCommand::Arguments, IFsrmActionCommand::get_Arguments, IFsrmActionCommand::put_Arguments, fs.ifsrmactioncommand_arguments, fsrm.ifsrmactioncommand_arguments, fsrm/IFsrmActionCommand::Arguments, fsrm/IFsrmActionCommand::get_Arguments, fsrm/IFsrmActionCommand::put_Arguments, put_Arguments
f1_keywords:
- fsrm/IFsrmActionCommand.Arguments
dev_langs:
- c++
req.header: fsrm.h
req.include-header: FsrmQuota.h, FsrmScreen.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmActionCommand.Arguments
- IFsrmActionCommand.get_Arguments
- IFsrmActionCommand.put_Arguments
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmActionCommand::put_Arguments


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmaction">MSFT_FSRMAction</a>,
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjaction">MSFT_FSRMFMJAction</a>, and 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjnotificationaction">MSFT_FSRMFMJNotificationAction</a> 
    classes.]

Retrieves or sets the arguments to pass to the executable program specified in the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrm/nf-fsrm-ifsrmactioncommand-get_executablepath">ExecutablePath</a> property.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrm/nn-fsrm-ifsrmactioncommand">IFsrmActionCommand</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmaction">MSFT_FSRMAction</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjaction">MSFT_FSRMFMJAction</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjnotificationaction">MSFT_FSRMFMJNotificationAction</a>
 

 

