---
UID: NF:fsrm.IFsrmActionEventLog.put_MessageText
title: IFsrmActionEventLog::put_MessageText (fsrm.h)
description: Retrieves or sets the event text that is logged when the action runs.
old-location: fsrm\ifsrmactioneventlog_messagetext.htm
tech.root: fsrm
ms.assetid: 3a883032-808a-47f9-845e-50bad5424304
ms.date: 12/05/2018
ms.keywords: IFsrmActionEventLog interface [File Server Resource Manager],MessageText property, IFsrmActionEventLog.MessageText, IFsrmActionEventLog.put_MessageText, IFsrmActionEventLog::MessageText, IFsrmActionEventLog::get_MessageText, IFsrmActionEventLog::put_MessageText, MessageText property [File Server Resource Manager], MessageText property [File Server Resource Manager],IFsrmActionEventLog interface, fs.ifsrmactioneventlog_messagetext, fsrm.ifsrmactioneventlog_messagetext, fsrm/IFsrmActionEventLog::MessageText, fsrm/IFsrmActionEventLog::get_MessageText, fsrm/IFsrmActionEventLog::put_MessageText, put_MessageText
f1_keywords:
- fsrm/IFsrmActionEventLog.MessageText
dev_langs:
- c++
req.header: fsrm.h
req.include-header: FsrmQuota.h, FsrmScreen.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmActionEventLog.MessageText
- IFsrmActionEventLog.get_MessageText
- IFsrmActionEventLog.put_MessageText
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmActionEventLog::put_MessageText


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmaction">MSFT_FSRMAction</a>,
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjaction">MSFT_FSRMFMJAction</a>, and 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjnotificationaction">MSFT_FSRMFMJNotificationAction</a> 
    classes.]

Retrieves or sets the event text that is logged when the action runs.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrm/nn-fsrm-ifsrmactioneventlog">IFsrmActionEventLog</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmaction">MSFT_FSRMAction</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjaction">MSFT_FSRMFMJAction</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjnotificationaction">MSFT_FSRMFMJNotificationAction</a>
 

 

