---
UID: NE:fsrmenums._AdrClientErrorType
title: AdrClientErrorType (fsrmenums.h)
description: Describes the possible access denied remediation (ADR) client error types.
old-location: fsrm\adrclienterrortype.htm
tech.root: fsrm
ms.assetid: 83e2c39b-ab3b-46c9-bb11-3f03f8193a7c
ms.date: 12/05/2018
ms.keywords: AdrClientErrorType, AdrClientErrorType enumeration [File Server Resource Manager], AdrClientErrorType_AccessDenied, AdrClientErrorType_Unknown, fs.adrclienterrortype, fsrm.adrclienterrortype, fsrmenums/AdrClientErrorType, fsrmenums/AdrClientErrorType_AccessDenied, fsrmenums/AdrClientErrorType_Unknown
f1_keywords:
- fsrmenums/AdrClientErrorType
dev_langs:
- c++
req.header: fsrmenums.h
req.include-header: FsrmPipeline.h, FsrmQuota.h, FsrmReports.h, FsrmScreen.h
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FsrmEnums.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- FsrmEnums.h
api_name:
- AdrClientErrorType
targetos: Windows
req.typenames: AdrClientErrorType
req.redist: 
ms.custom: 19H1
---

# AdrClientErrorType enumeration


## -description


Describes the possible access denied remediation (ADR) client error types.


## -enum-fields




### -field AdrClientErrorType_Unknown

The ADR client error type is unknown.


### -field AdrClientErrorType_AccessDenied

The ADR client error type is access denied.


### -field AdrClientErrorType_FileNotFound




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-enumerations">FSRM Enumerations</a>
 

 

