---
UID: NF:fsrmpipeline.IFsrmPropertyDefinition2.get_AppliesTo
title: IFsrmPropertyDefinition2::get_AppliesTo (fsrmpipeline.h)
description: This property contains flags with values from the FsrmPropertyDefinitionAppliesTo enumeration that indicate what a FSRM property definition can be applied to.
old-location: fsrm\ifsrmpropertydefinition2_appliesto.htm
tech.root: fsrm
ms.assetid: baa7e2a0-71d3-465e-a4aa-5908b28db703
ms.date: 12/05/2018
ms.keywords: AppliesTo property [File Server Resource Manager], AppliesTo property [File Server Resource Manager],IFsrmPropertyDefinition2 interface, IFsrmPropertyDefinition2 interface [File Server Resource Manager],AppliesTo property, IFsrmPropertyDefinition2.AppliesTo, IFsrmPropertyDefinition2.get_AppliesTo, IFsrmPropertyDefinition2::AppliesTo, IFsrmPropertyDefinition2::get_AppliesTo, fs.ifsrmpropertydefinition2_appliesto, fsrm.ifsrmpropertydefinition2_appliesto, fsrmpipeline/IFsrmPropertyDefinition2::AppliesTo, fsrmpipeline/IFsrmPropertyDefinition2::get_AppliesTo, get_AppliesTo
f1_keywords:
- fsrmpipeline/IFsrmPropertyDefinition2.AppliesTo
dev_langs:
- c++
req.header: fsrmpipeline.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FsrmPipeline.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmPropertyDefinition2.AppliesTo
- IFsrmPropertyDefinition2.get_AppliesTo
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmPropertyDefinition2::get_AppliesTo


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmclassificationpropertydefinition">MSFT_FSRMClassificationPropertyDefinition</a> 
    class.]

This property contains flags with values from the 
    <a href="https://docs.microsoft.com/windows/win32/api/fsrmenums/ne-fsrmenums-fsrmpropertydefinitionappliesto">FsrmPropertyDefinitionAppliesTo</a> enumeration 
    that indicate what a FSRM property definition can be applied to.

This property is read-only.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrmpipeline/nn-fsrmpipeline-ifsrmpropertydefinition2">IFsrmPropertyDefinition2</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmclassificationpropertydefinition">MSFT_FSRMClassificationPropertyDefinition</a>
 

 

