---
UID: NF:fsrmreports.IFsrmFileConditionProperty.get_PropertyId
title: IFsrmFileConditionProperty::get_PropertyId (fsrmreports.h)
description: Specifies the predefined file property, as enumerated by the FsrmFileSystemPropertyId enumeration.
old-location: fsrm\ifsrmfileconditionproperty_propertyid.htm
tech.root: fsrm
ms.assetid: 29f19f5e-5e33-41e5-8332-4634613b2bf4
ms.date: 12/05/2018
ms.keywords: IFsrmFileConditionProperty interface [File Server Resource Manager],PropertyId property, IFsrmFileConditionProperty.PropertyId, IFsrmFileConditionProperty.get_PropertyId, IFsrmFileConditionProperty::PropertyId, IFsrmFileConditionProperty::get_PropertyId, IFsrmFileConditionProperty::put_PropertyId, PropertyId property [File Server Resource Manager], PropertyId property [File Server Resource Manager],IFsrmFileConditionProperty interface, fs.ifsrmfileconditionproperty_propertyid, fsrm.ifsrmfileconditionproperty_propertyid, fsrmreports/IFsrmFileConditionProperty::PropertyId, fsrmreports/IFsrmFileConditionProperty::get_PropertyId, fsrmreports/IFsrmFileConditionProperty::put_PropertyId, get_PropertyId
f1_keywords:
- fsrmreports/IFsrmFileConditionProperty.PropertyId
dev_langs:
- c++
req.header: fsrmreports.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FsrmReports.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmFileConditionProperty.PropertyId
- IFsrmFileConditionProperty.get_PropertyId
- IFsrmFileConditionProperty.put_PropertyId
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmFileConditionProperty::get_PropertyId


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjcondition">MSFT_FSRMFMJCondition</a> class.]

Specifies the predefined file property, as enumerated by the 
    <a href="https://docs.microsoft.com/windows/desktop/api/fsrmenums/ne-fsrmenums-fsrmfilesystempropertyid">FsrmFileSystemPropertyId</a> enumeration.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/fsrmenums/ne-fsrmenums-fsrmfilesystempropertyid">FsrmFileSystemPropertyId</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrmreports/nn-fsrmreports-ifsrmfileconditionproperty">IFsrmFileConditionProperty</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjcondition">MSFT_FSRMFMJCondition</a>
 

 

