---
UID: NF:fsrmreports.IFsrmFileConditionProperty.get_ValueType
title: IFsrmFileConditionProperty::get_ValueType (fsrmreports.h)
description: Specifies the type of the file condition property value, as enumerated by the FsrmPropertyValueType enumeration.
old-location: fsrm\ifsrmfileconditionproperty_valuetype.htm
tech.root: fsrm
ms.assetid: 86086089-936a-428f-bc2b-514c873db1a3
ms.date: 12/05/2018
ms.keywords: IFsrmFileConditionProperty interface [File Server Resource Manager],ValueType property, IFsrmFileConditionProperty.ValueType, IFsrmFileConditionProperty.get_ValueType, IFsrmFileConditionProperty::ValueType, IFsrmFileConditionProperty::get_ValueType, IFsrmFileConditionProperty::put_ValueType, ValueType property [File Server Resource Manager], ValueType property [File Server Resource Manager],IFsrmFileConditionProperty interface, fs.ifsrmfileconditionproperty_valuetype, fsrm.ifsrmfileconditionproperty_valuetype, fsrmreports/IFsrmFileConditionProperty::ValueType, fsrmreports/IFsrmFileConditionProperty::get_ValueType, fsrmreports/IFsrmFileConditionProperty::put_ValueType, get_ValueType
f1_keywords:
- fsrmreports/IFsrmFileConditionProperty.ValueType
dev_langs:
- c++
req.header: fsrmreports.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2012
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FsrmReports.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmFileConditionProperty.ValueType
- IFsrmFileConditionProperty.get_ValueType
- IFsrmFileConditionProperty.put_ValueType
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmFileConditionProperty::get_ValueType


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjcondition">MSFT_FSRMFMJCondition</a> class.]

Specifies the type of the file condition property value, as enumerated by the 
    <a href="https://docs.microsoft.com/windows/desktop/api/fsrmenums/ne-fsrmenums-fsrmpropertyvaluetype">FsrmPropertyValueType</a> enumeration.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/fsrmenums/ne-fsrmenums-fsrmpropertyvaluetype">FsrmPropertyValueType</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrmreports/nn-fsrmreports-ifsrmfileconditionproperty">IFsrmFileConditionProperty</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfmjcondition">MSFT_FSRMFMJCondition</a>
 

 

