---
UID: NF:fsrmreports.IFsrmFileManagementJob.get_Parameters
title: IFsrmFileManagementJob::get_Parameters (fsrmreports.h)
description: The parameters for the file management job.
old-location: fsrm\ifsrmfilemanagementjob_parameters.htm
tech.root: fsrm
ms.assetid: 87eb994c-3d15-4c6b-90c3-1ddb340f7458
ms.date: 12/05/2018
ms.keywords: IFsrmFileManagementJob interface [File Server Resource Manager],Parameters property, IFsrmFileManagementJob.Parameters, IFsrmFileManagementJob.get_Parameters, IFsrmFileManagementJob::Parameters, IFsrmFileManagementJob::get_Parameters, IFsrmFileManagementJob::put_Parameters, Parameters property [File Server Resource Manager], Parameters property [File Server Resource Manager],IFsrmFileManagementJob interface, fs.ifsrmfilemanagementjob_parameters, fsrm.ifsrmfilemanagementjob_parameters, fsrmreports/IFsrmFileManagementJob::Parameters, fsrmreports/IFsrmFileManagementJob::get_Parameters, fsrmreports/IFsrmFileManagementJob::put_Parameters, get_Parameters
f1_keywords:
- fsrmreports/IFsrmFileManagementJob.Parameters
dev_langs:
- c++
req.header: fsrmreports.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008 R2
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmFileManagementJob.Parameters
- IFsrmFileManagementJob.get_Parameters
- IFsrmFileManagementJob.put_Parameters
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmFileManagementJob::get_Parameters


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfilemanagementjob">MSFT_FSRMFileManagementJob</a> class.]

The parameters for the file management job.

This property is read/write.


## -parameters


## -remarks



There is no limit to the length of the parameter name or value, nor is there a limit to the number of 
    parameters that you can specify. Specifying a parameter without a value is valid (for example, 
    "parameter=").




## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrmreports/nn-fsrmreports-ifsrmfilemanagementjob">IFsrmFileManagementJob</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfilemanagementjob">MSFT_FSRMFileManagementJob</a>
 

 

