---
UID: NF:fsrmscreen.IFsrmFileScreenException.get_AllowedFileGroups
title: IFsrmFileScreenException::get_AllowedFileGroups (fsrmscreen.h)
description: Retrieves or sets the names of the file groups that contain the file name patterns of the files that are allowed in the directory.
old-location: fsrm\ifsrmfilescreenexception_allowedfilegroups.htm
tech.root: fsrm
ms.assetid: e02070dd-a51d-4572-a282-4e5a151cd987
ms.date: 12/05/2018
ms.keywords: AllowedFileGroups property [File Server Resource Manager], AllowedFileGroups property [File Server Resource Manager],IFsrmFileScreenException interface, IFsrmFileScreenException interface [File Server Resource Manager],AllowedFileGroups property, IFsrmFileScreenException.AllowedFileGroups, IFsrmFileScreenException.get_AllowedFileGroups, IFsrmFileScreenException::AllowedFileGroups, IFsrmFileScreenException::get_AllowedFileGroups, IFsrmFileScreenException::put_AllowedFileGroups, fs.ifsrmfilescreenexception_allowedfilegroups, fsrm.ifsrmfilescreenexception_allowedfilegroups, fsrmscreen/IFsrmFileScreenException::AllowedFileGroups, fsrmscreen/IFsrmFileScreenException::get_AllowedFileGroups, fsrmscreen/IFsrmFileScreenException::put_AllowedFileGroups, get_AllowedFileGroups
f1_keywords:
- fsrmscreen/IFsrmFileScreenException.AllowedFileGroups
dev_langs:
- c++
req.header: fsrmscreen.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: None supported
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FsrmScreen.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: SrmSvc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- SrmSvc.dll
api_name:
- IFsrmFileScreenException.AllowedFileGroups
- IFsrmFileScreenException.get_AllowedFileGroups
- IFsrmFileScreenException.put_AllowedFileGroups
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFsrmFileScreenException::get_AllowedFileGroups


## -description


<p class="CCE_Message">[This property is supported for compatibility but it's recommended to use the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/fsrm-wmi-classes">FSRM WMI Classes</a> to manage FSRM. Please see the 
    <a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfilescreenexception">MSFT_FSRMFileScreenException</a> class.]

Retrieves or sets the names of the file groups that contain the file name patterns of the files that 
    are allowed in the directory.

This property is read/write.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/fsrmscreen/nn-fsrmscreen-ifsrmfilescreenexception">IFsrmFileScreenException</a>



<a href="https://docs.microsoft.com/previous-versions/windows/desktop/fsrm/msft-fsrmfilescreenexception">MSFT_FSRMFileScreenException</a>
 

 

