---
UID: NF:functiondiscoveryapi.IFunctionInstance.GetID
title: IFunctionInstance::GetID (functiondiscoveryapi.h)
description: Gets the identifier string for the function instance.
old-location: ncd\ifunctioninstance_getid_method.htm
tech.root: FunDisc
ms.assetid: 8a198bc4-cdec-4d46-a1a2-3952d4dc2a7d
ms.date: 12/05/2018
ms.keywords: GetID, GetID method, GetID method,IFunctionInstance interface, IFunctionInstance interface,GetID method, IFunctionInstance.GetID, IFunctionInstance::GetID, functiondiscoveryapi/IFunctionInstance::GetID, ncd.ifunctioninstance_getid_method
f1_keywords:
- functiondiscoveryapi/IFunctionInstance.GetID
dev_langs:
- c++
req.header: functiondiscoveryapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: FunctionDiscoveryAPI.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: FunDisc.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- FunDisc.dll
api_name:
- IFunctionInstance.GetID
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IFunctionInstance::GetID


## -description


<p class="CCE_Message">[Function Discovery is available for use in the operating systems specified in the Requirements section. It may be altered or unavailable in subsequent versions.]

Gets the identifier string for the function instance. This identifier can be saved and later used to re-query for the same function instance through <a href="https://docs.microsoft.com/windows/desktop/api/functiondiscoveryapi/nf-functiondiscoveryapi-ifunctiondiscovery-getinstance">IFunctionDiscovery::GetInstance</a>. 


## -parameters




### -param ppszCoMemIdentity [out]

The function instance identifier string. There is no upper limit on the size of this string. 

This string is a composed string generated by Function Discovery. It has the provider instance identifier string  as a substring. For more information about provider identifiers, see <a href="https://docs.microsoft.com/windows/desktop/api/functiondiscoveryapi/nf-functiondiscoveryapi-ifunctioninstance-getproviderinstanceid">IFunctionInstance::GetProviderInstanceID</a>.

For function instances returned by a built-in provider, this identifier is guaranteed to uniquely identify a resource on a system, even if the resource is disconnected and reconnected. For function instances returned by custom providers, the function instance identifier is unique if the provider has a unique provider identifier. 

This identifier should not be manipulated or manufactured programmatically. The string should only be used to retrieve function instances and for comparison purposes. 

Be sure to free this buffer using <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cotaskmemfree">CoTaskMemFree</a>.


## -returns



Possible return values include, but are not limited to, the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The method completed successfully.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
The value of <i>ppszCoMemID</i> is invalid.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_OUTOFMEMORY</b></dt>
</dl>
</td>
<td width="60%">
The method is unable to allocate the memory required to perform this operation.

</td>
</tr>
</table>
 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/functiondiscoveryapi/nn-functiondiscoveryapi-ifunctioninstance">IFunctionInstance</a>
 

 

