---
UID: NF:gdipluscolor.Color.GetValue
title: Color::GetValue (gdipluscolor.h)
description: The Color::GetValue method gets the ARGB value of this Color object.
old-location: gdiplus\_gdiplus_CLASS_Color_GetValue_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\colorclass\colormethods\getvalue.htm
ms.date: 12/05/2018
ms.keywords: Color class [GDI+],GetValue method, Color.GetValue, Color::GetValue, GetValue, GetValue method [GDI+], GetValue method [GDI+],Color class, _gdiplus_CLASS_Color_GetValue_, gdiplus._gdiplus_CLASS_Color_GetValue_
f1_keywords:
- gdipluscolor/Color.GetValue
dev_langs:
- c++
req.header: gdipluscolor.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Color.GetValue
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Color::GetValue


## -description


The <b>Color::GetValue</b> method gets the <b>ARGB</b> value of this <a href="https://docs.microsoft.com/windows/desktop/api/gdipluscolor/nl-gdipluscolor-color">Color</a> object.


## -parameters






## -returns



Type: <strong>Type: <b>ARGB</b>
</strong>

This method returns a 32-bit <b>ARGB</b> value that holds the alpha, red, green, and blue components of this color. <b>ARGB</b> is defined in Gdipluspixelformats.h.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdipluscolor/nl-gdipluscolor-color">Color</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdipluscolor/nf-gdipluscolor-color-makeargb">Color::MakeARGB</a>
 

 

