---
UID: NE:gdipluseffects.CurveChannel
title: CurveChannel (gdipluseffects.h)
description: The CurveChannel enumeration specifies which color channels are affected by a ColorCurve bitmap adjustment.
old-location: gdiplus\_gdiplus_ENUM_CurveChannel.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\curvechannel.htm
ms.date: 12/05/2018
ms.keywords: CurveChannel, CurveChannel enumeration [GDI+], CurveChannelAll, CurveChannelBlue, CurveChannelGreen, CurveChannelRed, _gdiplus_ENUM_CurveChannel, gdiplus._gdiplus_ENUM_CurveChannel, gdipluseffects/CurveChannel, gdipluseffects/CurveChannelAll, gdipluseffects/CurveChannelBlue, gdipluseffects/CurveChannelGreen, gdipluseffects/CurveChannelRed
f1_keywords:
- gdipluseffects/CurveChannel
dev_langs:
- c++
req.header: gdipluseffects.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- GdiplusEffects.h
api_name:
- CurveChannel
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# CurveChannel enumeration


## -description


The <b>CurveChannel</b> enumeration specifies which color channels are affected by a <a href="https://docs.microsoft.com/windows/desktop/api/gdipluseffects/nl-gdipluseffects-colorcurve">ColorCurve</a> bitmap adjustment.


## -enum-fields




### -field CurveChannelAll

Specifies that the color adjustment applies to all channels.


### -field CurveChannelRed

Specifies that the color adjustment applies only to the red channel.


### -field CurveChannelGreen

Specifies that the color adjustment applies only to the green channel.


### -field CurveChannelBlue

Specifies that the color adjustment applies only to the blue channel.

