---
UID: NF:gdipluseffects.Effect.GetAuxDataSize
title: Effect::GetAuxDataSize (gdipluseffects.h)
description: The Effect::GetAuxDataSize method gets the size, in bytes, of the auxiliary data created by a previous call to the Bitmap::ApplyEffect method.
old-location: gdiplus\_gdiplus_CLASS_Effect_GetAuxDataSize_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\effectclass\effectmethods\getauxdatasize.htm
ms.date: 12/05/2018
ms.keywords: Effect class [GDI+],GetAuxDataSize method, Effect.GetAuxDataSize, Effect::GetAuxDataSize, GetAuxDataSize, GetAuxDataSize method [GDI+], GetAuxDataSize method [GDI+],Effect class, _gdiplus_CLASS_Effect_GetAuxDataSize_, gdiplus._gdiplus_CLASS_Effect_GetAuxDataSize_
f1_keywords:
- gdipluseffects/Effect.GetAuxDataSize
dev_langs:
- c++
req.header: gdipluseffects.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Effect.GetAuxDataSize
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.1
ms.custom: 19H1
---

# Effect::GetAuxDataSize


## -description


The <b>Effect::GetAuxDataSize</b> method gets the size, in bytes, of the auxiliary data created by a previous call to the <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-bitmap-applyeffect(inbitmap_inint_ineffect_inrect_outrect_outbitmap)">Bitmap::ApplyEffect</a> method. 


## -parameters






## -returns



Type: <strong>Type: <b>INT</b>
</strong>

This method returns the size, in bytes, of the auxiliary data.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdipluseffects/nl-gdipluseffects-effect">Effect</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdipluseffects/nf-gdipluseffects-effect-getauxdata">Effect::GetAuxData</a>
 

 

