---
UID: NE:gdiplusenums.EmfPlusRecordType
title: EmfPlusRecordType (gdiplusenums.h)
description: The EmfPlusRecordType enumeration identifies metafile record types used in Windows Metafile Format (WMF), Enhanced Metafile (EMF), and EMF+ files. The elements of the EmfPlusRecordType enumeration come in three groups.
old-location: gdiplus\_gdiplus_ENUM_EmfPlusRecordType.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\emfplusrecordtype.htm
ms.date: 12/05/2018
ms.keywords: EmfPlusRecordTotal, EmfPlusRecordType, EmfPlusRecordType enumeration [GDI+], EmfPlusRecordTypeBeginContainer, EmfPlusRecordTypeBeginContainerNoParams, EmfPlusRecordTypeClear, EmfPlusRecordTypeComment, EmfPlusRecordTypeDrawArc, EmfPlusRecordTypeDrawBeziers, EmfPlusRecordTypeDrawClosedCurve, EmfPlusRecordTypeDrawCurve, EmfPlusRecordTypeDrawDriverString, EmfPlusRecordTypeDrawEllipse, EmfPlusRecordTypeDrawImage, EmfPlusRecordTypeDrawImagePoints, EmfPlusRecordTypeDrawLines, EmfPlusRecordTypeDrawPath, EmfPlusRecordTypeDrawPie, EmfPlusRecordTypeDrawRects, EmfPlusRecordTypeDrawString, EmfPlusRecordTypeEndContainer, EmfPlusRecordTypeEndOfFile, EmfPlusRecordTypeFillClosedCurve, EmfPlusRecordTypeFillEllipse, EmfPlusRecordTypeFillPath, EmfPlusRecordTypeFillPie, EmfPlusRecordTypeFillPolygon, EmfPlusRecordTypeFillRects, EmfPlusRecordTypeFillRegion, EmfPlusRecordTypeGetDC, EmfPlusRecordTypeHeader, EmfPlusRecordTypeInvalid, EmfPlusRecordTypeMax, EmfPlusRecordTypeMin, EmfPlusRecordTypeMultiFormatEnd, EmfPlusRecordTypeMultiFormatSection, EmfPlusRecordTypeMultiFormatStart, EmfPlusRecordTypeMultiplyWorldTransform, EmfPlusRecordTypeObject, EmfPlusRecordTypeOffsetClip, EmfPlusRecordTypeResetClip, EmfPlusRecordTypeResetWorldTransform, EmfPlusRecordTypeRestore, EmfPlusRecordTypeRotateWorldTransform, EmfPlusRecordTypeSave, EmfPlusRecordTypeScaleWorldTransform, EmfPlusRecordTypeSerializableObject, EmfPlusRecordTypeSetAntiAliasMode, EmfPlusRecordTypeSetClipPath, EmfPlusRecordTypeSetClipRect, EmfPlusRecordTypeSetClipRegion, EmfPlusRecordTypeSetCompositingMode, EmfPlusRecordTypeSetCompositingQuality, EmfPlusRecordTypeSetGammaValue, EmfPlusRecordTypeSetInterpolationMode, EmfPlusRecordTypeSetPageTransform, EmfPlusRecordTypeSetPixelOffsetMode, EmfPlusRecordTypeSetRenderingOrigin, EmfPlusRecordTypeSetTSClip, EmfPlusRecordTypeSetTSGraphics, EmfPlusRecordTypeSetTextContrast, EmfPlusRecordTypeSetTextRenderingHint, EmfPlusRecordTypeSetWorldTransform, EmfPlusRecordTypeStrokeFillPath, EmfPlusRecordTypeTranslateWorldTransform, EmfRecordTypeAbortPath, EmfRecordTypeAlphaBlend, EmfRecordTypeAngleArc, EmfRecordTypeArc, EmfRecordTypeArcTo, EmfRecordTypeBeginPath, EmfRecordTypeBitBlt, EmfRecordTypeChord, EmfRecordTypeCloseFigure, EmfRecordTypeColorCorrectPalette, EmfRecordTypeColorMatchToTargetW, EmfRecordTypeCreateBrushIndirect, EmfRecordTypeCreateColorSpace, EmfRecordTypeCreateColorSpaceW, EmfRecordTypeCreateDIBPatternBrushPt, EmfRecordTypeCreateMonoBrush, EmfRecordTypeCreatePalette, EmfRecordTypeCreatePen, EmfRecordTypeDeleteColorSpace, EmfRecordTypeDeleteObject, EmfRecordTypeDrawEscape, EmfRecordTypeEOF, EmfRecordTypeEllipse, EmfRecordTypeEndPath, EmfRecordTypeExcludeClipRect, EmfRecordTypeExtCreateFontIndirect, EmfRecordTypeExtCreatePen, EmfRecordTypeExtEscape, EmfRecordTypeExtFloodFill, EmfRecordTypeExtSelectClipRgn, EmfRecordTypeExtTextOutA, EmfRecordTypeExtTextOutW, EmfRecordTypeFillPath, EmfRecordTypeFillRgn, EmfRecordTypeFlattenPath, EmfRecordTypeForceUFIMapping, EmfRecordTypeFrameRgn, EmfRecordTypeGLSBoundedRecord, EmfRecordTypeGLSRecord, EmfRecordTypeGdiComment, EmfRecordTypeGradientFill, EmfRecordTypeHeader, EmfRecordTypeIntersectClipRect, EmfRecordTypeInvertRgn, EmfRecordTypeLineTo, EmfRecordTypeMaskBlt, EmfRecordTypeMax, EmfRecordTypeMin, EmfRecordTypeModifyWorldTransform, EmfRecordTypeMoveToEx, EmfRecordTypeNamedEscape, EmfRecordTypeOffsetClipRgn, EmfRecordTypePaintRgn, EmfRecordTypePie, EmfRecordTypePixelFormat, EmfRecordTypePlgBlt, EmfRecordTypePolyBezier, EmfRecordTypePolyBezier16, EmfRecordTypePolyBezierTo, EmfRecordTypePolyBezierTo16, EmfRecordTypePolyDraw, EmfRecordTypePolyDraw16, EmfRecordTypePolyLineTo, EmfRecordTypePolyPolygon, EmfRecordTypePolyPolygon16, EmfRecordTypePolyPolyline, EmfRecordTypePolyPolyline16, EmfRecordTypePolyTextOutA, EmfRecordTypePolyTextOutW, EmfRecordTypePolygon, EmfRecordTypePolygon16, EmfRecordTypePolyline, EmfRecordTypePolyline16, EmfRecordTypePolylineTo16, EmfRecordTypeRealizePalette, EmfRecordTypeRectangle, EmfRecordTypeReserved_069, EmfRecordTypeReserved_117, EmfRecordTypeResizePalette, EmfRecordTypeRestoreDC, EmfRecordTypeRoundRect, EmfRecordTypeSaveDC, EmfRecordTypeScaleViewportExtEx, EmfRecordTypeScaleWindowExtEx, EmfRecordTypeSelectClipPath, EmfRecordTypeSelectObject, EmfRecordTypeSelectPalette, EmfRecordTypeSetArcDirection, EmfRecordTypeSetBkColor, EmfRecordTypeSetBkMode, EmfRecordTypeSetBrushOrgEx, EmfRecordTypeSetColorAdjustment, EmfRecordTypeSetColorSpace, EmfRecordTypeSetDIBitsToDevice, EmfRecordTypeSetICMMode, EmfRecordTypeSetICMProfileA, EmfRecordTypeSetICMProfileW, EmfRecordTypeSetLayout, EmfRecordTypeSetLinkedUFIs, EmfRecordTypeSetMapMode, EmfRecordTypeSetMapperFlags, EmfRecordTypeSetMetaRgn, EmfRecordTypeSetMiterLimit, EmfRecordTypeSetPaletteEntries, EmfRecordTypeSetPixelV, EmfRecordTypeSetPolyFillMode, EmfRecordTypeSetROP2, EmfRecordTypeSetStretchBltMode, EmfRecordTypeSetTextAlign, EmfRecordTypeSetTextColor, EmfRecordTypeSetTextJustification, EmfRecordTypeSetViewportExtEx, EmfRecordTypeSetViewportOrgEx, EmfRecordTypeSetWindowExtEx, EmfRecordTypeSetWindowOrgEx, EmfRecordTypeSetWorldTransform, EmfRecordTypeSmallTextOut, EmfRecordTypeStartDoc, EmfRecordTypeStretchBlt, EmfRecordTypeStretchDIBits, EmfRecordTypeStrokeAndFillPath, EmfRecordTypeStrokePath, EmfRecordTypeTransparentBlt, EmfRecordTypeWidenPath, WmfRecordTypeAbortDoc, WmfRecordTypeAnimatePalette, WmfRecordTypeArc, WmfRecordTypeBitBlt, WmfRecordTypeChord, WmfRecordTypeCreateBitmap, WmfRecordTypeCreateBitmapIndirect, WmfRecordTypeCreateBrush, WmfRecordTypeCreateBrushIndirect, WmfRecordTypeCreateFontIndirect, WmfRecordTypeCreatePalette, WmfRecordTypeCreatePatternBrush, WmfRecordTypeCreatePenIndirect, WmfRecordTypeCreateRegion, WmfRecordTypeDIBBitBlt, WmfRecordTypeDIBCreatePatternBrush, WmfRecordTypeDIBStretchBlt, WmfRecordTypeDeleteObject, WmfRecordTypeDrawText, WmfRecordTypeEllipse, WmfRecordTypeEndDoc, WmfRecordTypeEndPage, WmfRecordTypeEscape, WmfRecordTypeExcludeClipRect, WmfRecordTypeExtFloodFill, WmfRecordTypeExtTextOut, WmfRecordTypeFillRegion, WmfRecordTypeFloodFill, WmfRecordTypeFrameRegion, WmfRecordTypeIntersectClipRect, WmfRecordTypeInvertRegion, WmfRecordTypeLineTo, WmfRecordTypeMoveTo, WmfRecordTypeOffsetClipRgn, WmfRecordTypeOffsetViewportOrg, WmfRecordTypeOffsetWindowOrg, WmfRecordTypePaintRegion, WmfRecordTypePatBlt, WmfRecordTypePie, WmfRecordTypePolyPolygon, WmfRecordTypePolygon, WmfRecordTypePolyline, WmfRecordTypeRealizePalette, WmfRecordTypeRectangle, WmfRecordTypeResetDC, WmfRecordTypeResizePalette, WmfRecordTypeRestoreDC, WmfRecordTypeRoundRect, WmfRecordTypeSaveDC, WmfRecordTypeScaleViewportExt, WmfRecordTypeScaleWindowExt, WmfRecordTypeSelectClipRegion, WmfRecordTypeSelectObject, WmfRecordTypeSelectPalette, WmfRecordTypeSetBkColor, WmfRecordTypeSetBkMode, WmfRecordTypeSetDIBToDev, WmfRecordTypeSetLayout, WmfRecordTypeSetMapMode, WmfRecordTypeSetMapperFlags, WmfRecordTypeSetPalEntries, WmfRecordTypeSetPixel, WmfRecordTypeSetPolyFillMode, WmfRecordTypeSetROP2, WmfRecordTypeSetRelAbs, WmfRecordTypeSetStretchBltMode, WmfRecordTypeSetTextAlign, WmfRecordTypeSetTextCharExtra, WmfRecordTypeSetTextColor, WmfRecordTypeSetTextJustification, WmfRecordTypeSetViewportExt, WmfRecordTypeSetViewportOrg, WmfRecordTypeSetWindowExt, WmfRecordTypeSetWindowOrg, WmfRecordTypeStartDoc, WmfRecordTypeStartPage, WmfRecordTypeStretchBlt, WmfRecordTypeStretchDIB, WmfRecordTypeTextOut, _gdiplus_ENUM_EmfPlusRecordType, gdiplus._gdiplus_ENUM_EmfPlusRecordType, gdiplusenums/EmfPlusRecordTotal, gdiplusenums/EmfPlusRecordType, gdiplusenums/EmfPlusRecordTypeBeginContainer, gdiplusenums/EmfPlusRecordTypeBeginContainerNoParams, gdiplusenums/EmfPlusRecordTypeClear, gdiplusenums/EmfPlusRecordTypeComment, gdiplusenums/EmfPlusRecordTypeDrawArc, gdiplusenums/EmfPlusRecordTypeDrawBeziers, gdiplusenums/EmfPlusRecordTypeDrawClosedCurve, gdiplusenums/EmfPlusRecordTypeDrawCurve, gdiplusenums/EmfPlusRecordTypeDrawDriverString, gdiplusenums/EmfPlusRecordTypeDrawEllipse, gdiplusenums/EmfPlusRecordTypeDrawImage, gdiplusenums/EmfPlusRecordTypeDrawImagePoints, gdiplusenums/EmfPlusRecordTypeDrawLines, gdiplusenums/EmfPlusRecordTypeDrawPath, gdiplusenums/EmfPlusRecordTypeDrawPie, gdiplusenums/EmfPlusRecordTypeDrawRects, gdiplusenums/EmfPlusRecordTypeDrawString, gdiplusenums/EmfPlusRecordTypeEndContainer, gdiplusenums/EmfPlusRecordTypeEndOfFile, gdiplusenums/EmfPlusRecordTypeFillClosedCurve, gdiplusenums/EmfPlusRecordTypeFillEllipse, gdiplusenums/EmfPlusRecordTypeFillPath, gdiplusenums/EmfPlusRecordTypeFillPie, gdiplusenums/EmfPlusRecordTypeFillPolygon, gdiplusenums/EmfPlusRecordTypeFillRects, gdiplusenums/EmfPlusRecordTypeFillRegion, gdiplusenums/EmfPlusRecordTypeGetDC, gdiplusenums/EmfPlusRecordTypeHeader, gdiplusenums/EmfPlusRecordTypeInvalid, gdiplusenums/EmfPlusRecordTypeMax, gdiplusenums/EmfPlusRecordTypeMin, gdiplusenums/EmfPlusRecordTypeMultiFormatEnd, gdiplusenums/EmfPlusRecordTypeMultiFormatSection, gdiplusenums/EmfPlusRecordTypeMultiFormatStart, gdiplusenums/EmfPlusRecordTypeMultiplyWorldTransform, gdiplusenums/EmfPlusRecordTypeObject, gdiplusenums/EmfPlusRecordTypeOffsetClip, gdiplusenums/EmfPlusRecordTypeResetClip, gdiplusenums/EmfPlusRecordTypeResetWorldTransform, gdiplusenums/EmfPlusRecordTypeRestore, gdiplusenums/EmfPlusRecordTypeRotateWorldTransform, gdiplusenums/EmfPlusRecordTypeSave, gdiplusenums/EmfPlusRecordTypeScaleWorldTransform, gdiplusenums/EmfPlusRecordTypeSerializableObject, gdiplusenums/EmfPlusRecordTypeSetAntiAliasMode, gdiplusenums/EmfPlusRecordTypeSetClipPath, gdiplusenums/EmfPlusRecordTypeSetClipRect, gdiplusenums/EmfPlusRecordTypeSetClipRegion, gdiplusenums/EmfPlusRecordTypeSetCompositingMode, gdiplusenums/EmfPlusRecordTypeSetCompositingQuality, gdiplusenums/EmfPlusRecordTypeSetGammaValue, gdiplusenums/EmfPlusRecordTypeSetInterpolationMode, gdiplusenums/EmfPlusRecordTypeSetPageTransform, gdiplusenums/EmfPlusRecordTypeSetPixelOffsetMode, gdiplusenums/EmfPlusRecordTypeSetRenderingOrigin, gdiplusenums/EmfPlusRecordTypeSetTSClip, gdiplusenums/EmfPlusRecordTypeSetTSGraphics, gdiplusenums/EmfPlusRecordTypeSetTextContrast, gdiplusenums/EmfPlusRecordTypeSetTextRenderingHint, gdiplusenums/EmfPlusRecordTypeSetWorldTransform, gdiplusenums/EmfPlusRecordTypeStrokeFillPath, gdiplusenums/EmfPlusRecordTypeTranslateWorldTransform, gdiplusenums/EmfRecordTypeAbortPath, gdiplusenums/EmfRecordTypeAlphaBlend, gdiplusenums/EmfRecordTypeAngleArc, gdiplusenums/EmfRecordTypeArc, gdiplusenums/EmfRecordTypeArcTo, gdiplusenums/EmfRecordTypeBeginPath, gdiplusenums/EmfRecordTypeBitBlt, gdiplusenums/EmfRecordTypeChord, gdiplusenums/EmfRecordTypeCloseFigure, gdiplusenums/EmfRecordTypeColorCorrectPalette, gdiplusenums/EmfRecordTypeColorMatchToTargetW, gdiplusenums/EmfRecordTypeCreateBrushIndirect, gdiplusenums/EmfRecordTypeCreateColorSpace, gdiplusenums/EmfRecordTypeCreateColorSpaceW, gdiplusenums/EmfRecordTypeCreateDIBPatternBrushPt, gdiplusenums/EmfRecordTypeCreateMonoBrush, gdiplusenums/EmfRecordTypeCreatePalette, gdiplusenums/EmfRecordTypeCreatePen, gdiplusenums/EmfRecordTypeDeleteColorSpace, gdiplusenums/EmfRecordTypeDeleteObject, gdiplusenums/EmfRecordTypeDrawEscape, gdiplusenums/EmfRecordTypeEOF, gdiplusenums/EmfRecordTypeEllipse, gdiplusenums/EmfRecordTypeEndPath, gdiplusenums/EmfRecordTypeExcludeClipRect, gdiplusenums/EmfRecordTypeExtCreateFontIndirect, gdiplusenums/EmfRecordTypeExtCreatePen, gdiplusenums/EmfRecordTypeExtEscape, gdiplusenums/EmfRecordTypeExtFloodFill, gdiplusenums/EmfRecordTypeExtSelectClipRgn, gdiplusenums/EmfRecordTypeExtTextOutA, gdiplusenums/EmfRecordTypeExtTextOutW, gdiplusenums/EmfRecordTypeFillPath, gdiplusenums/EmfRecordTypeFillRgn, gdiplusenums/EmfRecordTypeFlattenPath, gdiplusenums/EmfRecordTypeForceUFIMapping, gdiplusenums/EmfRecordTypeFrameRgn, gdiplusenums/EmfRecordTypeGLSBoundedRecord, gdiplusenums/EmfRecordTypeGLSRecord, gdiplusenums/EmfRecordTypeGdiComment, gdiplusenums/EmfRecordTypeGradientFill, gdiplusenums/EmfRecordTypeHeader, gdiplusenums/EmfRecordTypeIntersectClipRect, gdiplusenums/EmfRecordTypeInvertRgn, gdiplusenums/EmfRecordTypeLineTo, gdiplusenums/EmfRecordTypeMaskBlt, gdiplusenums/EmfRecordTypeMax, gdiplusenums/EmfRecordTypeMin, gdiplusenums/EmfRecordTypeModifyWorldTransform, gdiplusenums/EmfRecordTypeMoveToEx, gdiplusenums/EmfRecordTypeNamedEscape, gdiplusenums/EmfRecordTypeOffsetClipRgn, gdiplusenums/EmfRecordTypePaintRgn, gdiplusenums/EmfRecordTypePie, gdiplusenums/EmfRecordTypePixelFormat, gdiplusenums/EmfRecordTypePlgBlt, gdiplusenums/EmfRecordTypePolyBezier, gdiplusenums/EmfRecordTypePolyBezier16, gdiplusenums/EmfRecordTypePolyBezierTo, gdiplusenums/EmfRecordTypePolyBezierTo16, gdiplusenums/EmfRecordTypePolyDraw, gdiplusenums/EmfRecordTypePolyDraw16, gdiplusenums/EmfRecordTypePolyLineTo, gdiplusenums/EmfRecordTypePolyPolygon, gdiplusenums/EmfRecordTypePolyPolygon16, gdiplusenums/EmfRecordTypePolyPolyline, gdiplusenums/EmfRecordTypePolyPolyline16, gdiplusenums/EmfRecordTypePolyTextOutA, gdiplusenums/EmfRecordTypePolyTextOutW, gdiplusenums/EmfRecordTypePolygon, gdiplusenums/EmfRecordTypePolygon16, gdiplusenums/EmfRecordTypePolyline, gdiplusenums/EmfRecordTypePolyline16, gdiplusenums/EmfRecordTypePolylineTo16, gdiplusenums/EmfRecordTypeRealizePalette, gdiplusenums/EmfRecordTypeRectangle, gdiplusenums/EmfRecordTypeReserved_069, gdiplusenums/EmfRecordTypeReserved_117, gdiplusenums/EmfRecordTypeResizePalette, gdiplusenums/EmfRecordTypeRestoreDC, gdiplusenums/EmfRecordTypeRoundRect, gdiplusenums/EmfRecordTypeSaveDC, gdiplusenums/EmfRecordTypeScaleViewportExtEx, gdiplusenums/EmfRecordTypeScaleWindowExtEx, gdiplusenums/EmfRecordTypeSelectClipPath, gdiplusenums/EmfRecordTypeSelectObject, gdiplusenums/EmfRecordTypeSelectPalette, gdiplusenums/EmfRecordTypeSetArcDirection, gdiplusenums/EmfRecordTypeSetBkColor, gdiplusenums/EmfRecordTypeSetBkMode, gdiplusenums/EmfRecordTypeSetBrushOrgEx, gdiplusenums/EmfRecordTypeSetColorAdjustment, gdiplusenums/EmfRecordTypeSetColorSpace, gdiplusenums/EmfRecordTypeSetDIBitsToDevice, gdiplusenums/EmfRecordTypeSetICMMode, gdiplusenums/EmfRecordTypeSetICMProfileA, gdiplusenums/EmfRecordTypeSetICMProfileW, gdiplusenums/EmfRecordTypeSetLayout, gdiplusenums/EmfRecordTypeSetLinkedUFIs, gdiplusenums/EmfRecordTypeSetMapMode, gdiplusenums/EmfRecordTypeSetMapperFlags, gdiplusenums/EmfRecordTypeSetMetaRgn, gdiplusenums/EmfRecordTypeSetMiterLimit, gdiplusenums/EmfRecordTypeSetPaletteEntries, gdiplusenums/EmfRecordTypeSetPixelV, gdiplusenums/EmfRecordTypeSetPolyFillMode, gdiplusenums/EmfRecordTypeSetROP2, gdiplusenums/EmfRecordTypeSetStretchBltMode, gdiplusenums/EmfRecordTypeSetTextAlign, gdiplusenums/EmfRecordTypeSetTextColor, gdiplusenums/EmfRecordTypeSetTextJustification, gdiplusenums/EmfRecordTypeSetViewportExtEx, gdiplusenums/EmfRecordTypeSetViewportOrgEx, gdiplusenums/EmfRecordTypeSetWindowExtEx, gdiplusenums/EmfRecordTypeSetWindowOrgEx, gdiplusenums/EmfRecordTypeSetWorldTransform, gdiplusenums/EmfRecordTypeSmallTextOut, gdiplusenums/EmfRecordTypeStartDoc, gdiplusenums/EmfRecordTypeStretchBlt, gdiplusenums/EmfRecordTypeStretchDIBits, gdiplusenums/EmfRecordTypeStrokeAndFillPath, gdiplusenums/EmfRecordTypeStrokePath, gdiplusenums/EmfRecordTypeTransparentBlt, gdiplusenums/EmfRecordTypeWidenPath, gdiplusenums/WmfRecordTypeAbortDoc, gdiplusenums/WmfRecordTypeAnimatePalette, gdiplusenums/WmfRecordTypeArc, gdiplusenums/WmfRecordTypeBitBlt, gdiplusenums/WmfRecordTypeChord, gdiplusenums/WmfRecordTypeCreateBitmap, gdiplusenums/WmfRecordTypeCreateBitmapIndirect, gdiplusenums/WmfRecordTypeCreateBrush, gdiplusenums/WmfRecordTypeCreateBrushIndirect, gdiplusenums/WmfRecordTypeCreateFontIndirect, gdiplusenums/WmfRecordTypeCreatePalette, gdiplusenums/WmfRecordTypeCreatePatternBrush, gdiplusenums/WmfRecordTypeCreatePenIndirect, gdiplusenums/WmfRecordTypeCreateRegion, gdiplusenums/WmfRecordTypeDIBBitBlt, gdiplusenums/WmfRecordTypeDIBCreatePatternBrush, gdiplusenums/WmfRecordTypeDIBStretchBlt, gdiplusenums/WmfRecordTypeDeleteObject, gdiplusenums/WmfRecordTypeDrawText, gdiplusenums/WmfRecordTypeEllipse, gdiplusenums/WmfRecordTypeEndDoc, gdiplusenums/WmfRecordTypeEndPage, gdiplusenums/WmfRecordTypeEscape, gdiplusenums/WmfRecordTypeExcludeClipRect, gdiplusenums/WmfRecordTypeExtFloodFill, gdiplusenums/WmfRecordTypeExtTextOut, gdiplusenums/WmfRecordTypeFillRegion, gdiplusenums/WmfRecordTypeFloodFill, gdiplusenums/WmfRecordTypeFrameRegion, gdiplusenums/WmfRecordTypeIntersectClipRect, gdiplusenums/WmfRecordTypeInvertRegion, gdiplusenums/WmfRecordTypeLineTo, gdiplusenums/WmfRecordTypeMoveTo, gdiplusenums/WmfRecordTypeOffsetClipRgn, gdiplusenums/WmfRecordTypeOffsetViewportOrg, gdiplusenums/WmfRecordTypeOffsetWindowOrg, gdiplusenums/WmfRecordTypePaintRegion, gdiplusenums/WmfRecordTypePatBlt, gdiplusenums/WmfRecordTypePie, gdiplusenums/WmfRecordTypePolyPolygon, gdiplusenums/WmfRecordTypePolygon, gdiplusenums/WmfRecordTypePolyline, gdiplusenums/WmfRecordTypeRealizePalette, gdiplusenums/WmfRecordTypeRectangle, gdiplusenums/WmfRecordTypeResetDC, gdiplusenums/WmfRecordTypeResizePalette, gdiplusenums/WmfRecordTypeRestoreDC, gdiplusenums/WmfRecordTypeRoundRect, gdiplusenums/WmfRecordTypeSaveDC, gdiplusenums/WmfRecordTypeScaleViewportExt, gdiplusenums/WmfRecordTypeScaleWindowExt, gdiplusenums/WmfRecordTypeSelectClipRegion, gdiplusenums/WmfRecordTypeSelectObject, gdiplusenums/WmfRecordTypeSelectPalette, gdiplusenums/WmfRecordTypeSetBkColor, gdiplusenums/WmfRecordTypeSetBkMode, gdiplusenums/WmfRecordTypeSetDIBToDev, gdiplusenums/WmfRecordTypeSetLayout, gdiplusenums/WmfRecordTypeSetMapMode, gdiplusenums/WmfRecordTypeSetMapperFlags, gdiplusenums/WmfRecordTypeSetPalEntries, gdiplusenums/WmfRecordTypeSetPixel, gdiplusenums/WmfRecordTypeSetPolyFillMode, gdiplusenums/WmfRecordTypeSetROP2, gdiplusenums/WmfRecordTypeSetRelAbs, gdiplusenums/WmfRecordTypeSetStretchBltMode, gdiplusenums/WmfRecordTypeSetTextAlign, gdiplusenums/WmfRecordTypeSetTextCharExtra, gdiplusenums/WmfRecordTypeSetTextColor, gdiplusenums/WmfRecordTypeSetTextJustification, gdiplusenums/WmfRecordTypeSetViewportExt, gdiplusenums/WmfRecordTypeSetViewportOrg, gdiplusenums/WmfRecordTypeSetWindowExt, gdiplusenums/WmfRecordTypeSetWindowOrg, gdiplusenums/WmfRecordTypeStartDoc, gdiplusenums/WmfRecordTypeStartPage, gdiplusenums/WmfRecordTypeStretchBlt, gdiplusenums/WmfRecordTypeStretchDIB, gdiplusenums/WmfRecordTypeTextOut
f1_keywords:
- gdiplusenums/EmfPlusRecordType
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- EmfPlusRecordType
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.1
ms.custom: 19H1
---

# EmfPlusRecordType enumeration


## -description


The <b>EmfPlusRecordType</b> enumeration identifies metafile record types used in Windows Metafile Format (WMF), Enhanced Metafile (EMF), and EMF+ files. The elements of the <b>EmfPlusRecordType</b> enumeration come in three groups.
<ul>
<li>Elements in the first group have the prefix WmfRecordType and identity WMF records.</li>
<li>Elements in the second group have the prefix EmfRecordType and identify EMF records.</li>
<li>Elements in the third group have the prefix EmfPlusRecordType and identify EMF+ records.</li>
</ul>WMF and EMF records can be displayed by Windows GDI+ and by Windows Graphics Device Interface (GDI). EMF+ records can be displayed by GDI+ but not by GDI.

Elements that have the WmfRecordType prefix are analogous to constants (defined in Wingdi.h) that have the prefix META_. For example, the element <b><b>WmfRecordTypeSetBkColor</b></b> is analogous to the constant META_SETBKCOLOR. For more information about WMF files, see <a href="https://docs.microsoft.com/windows/desktop/gdi/windows-format-metafiles">Windows-Format Metafiles</a>.

Elements that have the EmfRecordType prefix are analogous to constants (defined in Wingdi.h) that have the prefix EMR_. For example, the element <b><b>EmfRecordTypePolygon</b></b> is analogous to the constant EMR_POLYGON. For more information about EMR constants, see <a href="https://docs.microsoft.com/windows/desktop/api/wingdi/ns-wingdi-emr">EMR</a>.

Elements that have the EmfPlusRecordType prefix are specific to GDI+. Most of those elements correspond to methods of the <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nl-gdiplusgraphics-graphics">Graphics</a> class. The remaining elements identify the header, the end of the file, and other sections of the metafile. The Constants section of this topic shows the correspondence between the EMF+ record types and the methods of the <b>Graphics</b> class.


## -enum-fields




### -field WmfRecordTypeSetBkColor


### -field WmfRecordTypeSetBkMode


### -field WmfRecordTypeSetMapMode


### -field WmfRecordTypeSetROP2


### -field WmfRecordTypeSetRelAbs


### -field WmfRecordTypeSetPolyFillMode


### -field WmfRecordTypeSetStretchBltMode


### -field WmfRecordTypeSetTextCharExtra


### -field WmfRecordTypeSetTextColor


### -field WmfRecordTypeSetTextJustification


### -field WmfRecordTypeSetWindowOrg


### -field WmfRecordTypeSetWindowExt


### -field WmfRecordTypeSetViewportOrg


### -field WmfRecordTypeSetViewportExt


### -field WmfRecordTypeOffsetWindowOrg


### -field WmfRecordTypeScaleWindowExt


### -field WmfRecordTypeOffsetViewportOrg


### -field WmfRecordTypeScaleViewportExt


### -field WmfRecordTypeLineTo


### -field WmfRecordTypeMoveTo


### -field WmfRecordTypeExcludeClipRect


### -field WmfRecordTypeIntersectClipRect


### -field WmfRecordTypeArc


### -field WmfRecordTypeEllipse


### -field WmfRecordTypeFloodFill


### -field WmfRecordTypePie


### -field WmfRecordTypeRectangle


### -field WmfRecordTypeRoundRect


### -field WmfRecordTypePatBlt


### -field WmfRecordTypeSaveDC


### -field WmfRecordTypeSetPixel


### -field WmfRecordTypeOffsetClipRgn


### -field WmfRecordTypeTextOut


### -field WmfRecordTypeBitBlt


### -field WmfRecordTypeStretchBlt


### -field WmfRecordTypePolygon


### -field WmfRecordTypePolyline


### -field WmfRecordTypeEscape


### -field WmfRecordTypeRestoreDC


### -field WmfRecordTypeFillRegion


### -field WmfRecordTypeFrameRegion


### -field WmfRecordTypeInvertRegion


### -field WmfRecordTypePaintRegion


### -field WmfRecordTypeSelectClipRegion


### -field WmfRecordTypeSelectObject


### -field WmfRecordTypeSetTextAlign


### -field WmfRecordTypeDrawText


### -field WmfRecordTypeChord


### -field WmfRecordTypeSetMapperFlags


### -field WmfRecordTypeExtTextOut


### -field WmfRecordTypeSetDIBToDev


### -field WmfRecordTypeSelectPalette


### -field WmfRecordTypeRealizePalette


### -field WmfRecordTypeAnimatePalette


### -field WmfRecordTypeSetPalEntries


### -field WmfRecordTypePolyPolygon


### -field WmfRecordTypeResizePalette


### -field WmfRecordTypeDIBBitBlt


### -field WmfRecordTypeDIBStretchBlt


### -field WmfRecordTypeDIBCreatePatternBrush


### -field WmfRecordTypeStretchDIB


### -field WmfRecordTypeExtFloodFill


### -field WmfRecordTypeSetLayout


### -field WmfRecordTypeResetDC


### -field WmfRecordTypeStartDoc


### -field WmfRecordTypeStartPage


### -field WmfRecordTypeEndPage


### -field WmfRecordTypeAbortDoc


### -field WmfRecordTypeEndDoc


### -field WmfRecordTypeDeleteObject


### -field WmfRecordTypeCreatePalette


### -field WmfRecordTypeCreateBrush


### -field WmfRecordTypeCreatePatternBrush


### -field WmfRecordTypeCreatePenIndirect


### -field WmfRecordTypeCreateFontIndirect


### -field WmfRecordTypeCreateBrushIndirect


### -field WmfRecordTypeCreateBitmapIndirect


### -field WmfRecordTypeCreateBitmap


### -field WmfRecordTypeCreateRegion


### -field EmfRecordTypeHeader


### -field EmfRecordTypePolyBezier


### -field EmfRecordTypePolygon


### -field EmfRecordTypePolyline


### -field EmfRecordTypePolyBezierTo


### -field EmfRecordTypePolyLineTo


### -field EmfRecordTypePolyPolyline


### -field EmfRecordTypePolyPolygon


### -field EmfRecordTypeSetWindowExtEx


### -field EmfRecordTypeSetWindowOrgEx


### -field EmfRecordTypeSetViewportExtEx


### -field EmfRecordTypeSetViewportOrgEx


### -field EmfRecordTypeSetBrushOrgEx


### -field EmfRecordTypeEOF


### -field EmfRecordTypeSetPixelV


### -field EmfRecordTypeSetMapperFlags


### -field EmfRecordTypeSetMapMode


### -field EmfRecordTypeSetBkMode


### -field EmfRecordTypeSetPolyFillMode


### -field EmfRecordTypeSetROP2


### -field EmfRecordTypeSetStretchBltMode


### -field EmfRecordTypeSetTextAlign


### -field EmfRecordTypeSetColorAdjustment


### -field EmfRecordTypeSetTextColor


### -field EmfRecordTypeSetBkColor


### -field EmfRecordTypeOffsetClipRgn


### -field EmfRecordTypeMoveToEx


### -field EmfRecordTypeSetMetaRgn


### -field EmfRecordTypeExcludeClipRect


### -field EmfRecordTypeIntersectClipRect


### -field EmfRecordTypeScaleViewportExtEx


### -field EmfRecordTypeScaleWindowExtEx


### -field EmfRecordTypeSaveDC


### -field EmfRecordTypeRestoreDC


### -field EmfRecordTypeSetWorldTransform


### -field EmfRecordTypeModifyWorldTransform


### -field EmfRecordTypeSelectObject


### -field EmfRecordTypeCreatePen


### -field EmfRecordTypeCreateBrushIndirect


### -field EmfRecordTypeDeleteObject


### -field EmfRecordTypeAngleArc


### -field EmfRecordTypeEllipse


### -field EmfRecordTypeRectangle


### -field EmfRecordTypeRoundRect


### -field EmfRecordTypeArc


### -field EmfRecordTypeChord


### -field EmfRecordTypePie


### -field EmfRecordTypeSelectPalette


### -field EmfRecordTypeCreatePalette


### -field EmfRecordTypeSetPaletteEntries


### -field EmfRecordTypeResizePalette


### -field EmfRecordTypeRealizePalette


### -field EmfRecordTypeExtFloodFill


### -field EmfRecordTypeLineTo


### -field EmfRecordTypeArcTo


### -field EmfRecordTypePolyDraw


### -field EmfRecordTypeSetArcDirection


### -field EmfRecordTypeSetMiterLimit


### -field EmfRecordTypeBeginPath


### -field EmfRecordTypeEndPath


### -field EmfRecordTypeCloseFigure


### -field EmfRecordTypeFillPath


### -field EmfRecordTypeStrokeAndFillPath


### -field EmfRecordTypeStrokePath


### -field EmfRecordTypeFlattenPath


### -field EmfRecordTypeWidenPath


### -field EmfRecordTypeSelectClipPath


### -field EmfRecordTypeAbortPath


### -field EmfRecordTypeReserved_069


### -field EmfRecordTypeGdiComment


### -field EmfRecordTypeFillRgn


### -field EmfRecordTypeFrameRgn


### -field EmfRecordTypeInvertRgn


### -field EmfRecordTypePaintRgn


### -field EmfRecordTypeExtSelectClipRgn


### -field EmfRecordTypeBitBlt


### -field EmfRecordTypeStretchBlt


### -field EmfRecordTypeMaskBlt


### -field EmfRecordTypePlgBlt


### -field EmfRecordTypeSetDIBitsToDevice


### -field EmfRecordTypeStretchDIBits


### -field EmfRecordTypeExtCreateFontIndirect


### -field EmfRecordTypeExtTextOutA


### -field EmfRecordTypeExtTextOutW


### -field EmfRecordTypePolyBezier16


### -field EmfRecordTypePolygon16


### -field EmfRecordTypePolyline16


### -field EmfRecordTypePolyBezierTo16


### -field EmfRecordTypePolylineTo16


### -field EmfRecordTypePolyPolyline16


### -field EmfRecordTypePolyPolygon16


### -field EmfRecordTypePolyDraw16


### -field EmfRecordTypeCreateMonoBrush


### -field EmfRecordTypeCreateDIBPatternBrushPt


### -field EmfRecordTypeExtCreatePen


### -field EmfRecordTypePolyTextOutA


### -field EmfRecordTypePolyTextOutW


### -field EmfRecordTypeSetICMMode


### -field EmfRecordTypeCreateColorSpace


### -field EmfRecordTypeSetColorSpace


### -field EmfRecordTypeDeleteColorSpace


### -field EmfRecordTypeGLSRecord


### -field EmfRecordTypeGLSBoundedRecord


### -field EmfRecordTypePixelFormat


### -field EmfRecordTypeDrawEscape


### -field EmfRecordTypeExtEscape


### -field EmfRecordTypeStartDoc


### -field EmfRecordTypeSmallTextOut


### -field EmfRecordTypeForceUFIMapping


### -field EmfRecordTypeNamedEscape


### -field EmfRecordTypeColorCorrectPalette


### -field EmfRecordTypeSetICMProfileA


### -field EmfRecordTypeSetICMProfileW


### -field EmfRecordTypeAlphaBlend


### -field EmfRecordTypeSetLayout


### -field EmfRecordTypeTransparentBlt


### -field EmfRecordTypeReserved_117


### -field EmfRecordTypeGradientFill


### -field EmfRecordTypeSetLinkedUFIs


### -field EmfRecordTypeSetTextJustification


### -field EmfRecordTypeColorMatchToTargetW


### -field EmfRecordTypeCreateColorSpaceW


### -field EmfRecordTypeMax


### -field EmfRecordTypeMin


### -field EmfPlusRecordTypeInvalid


### -field EmfPlusRecordTypeHeader

Identifies a record that is the EMF+ header.


### -field EmfPlusRecordTypeEndOfFile

Identifies a record that marks the last EMF+ record of a metafile.


### -field EmfPlusRecordTypeComment


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-addmetafilecomment">Graphics::AddMetafileComment</a>



### -field EmfPlusRecordTypeGetDC


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-gethdc">Graphics::GetHDC</a>



### -field EmfPlusRecordTypeMultiFormatStart

Identifies the start of a multiple-format block.


### -field EmfPlusRecordTypeMultiFormatSection

Identifies a section in a multiple-format block. Multiple-format records allow the same set of records to be represented in several formats.


### -field EmfPlusRecordTypeMultiFormatEnd

Identifies the end of a multiple-format block.


### -field EmfPlusRecordTypeObject


### -field EmfPlusRecordTypeClear


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-clear">Graphics::Clear</a>



### -field EmfPlusRecordTypeFillRects


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillrectangles(inconstbrush_inconstrect_inint)">FillRectangles Methods</a>



### -field EmfPlusRecordTypeDrawRects


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawrectangles(inconstpen_inconstrect_inint)">DrawRectangles Methods</a>



### -field EmfPlusRecordTypeFillPolygon


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillpolygon(inconstbrush_inconstpointf_inint_infillmode)">FillPolygon Methods</a>



### -field EmfPlusRecordTypeDrawLines


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawlines(inconstpen_inconstpoint_inint)">DrawLines Methods</a>



### -field EmfPlusRecordTypeFillEllipse


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillellipse(inconstbrush_inconstrect_)">FillEllipse Methods</a>



### -field EmfPlusRecordTypeDrawEllipse


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawellipse(inconstpen_inconstrect_)">DrawEllipse Methods</a>



### -field EmfPlusRecordTypeFillPie


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillpie(inconstbrush_inconstrect__inreal_inreal)">FillPie Methods</a>



### -field EmfPlusRecordTypeDrawPie


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawpie(inconstpen_inconstrect__inreal_inreal)">DrawPie Methods</a>



### -field EmfPlusRecordTypeDrawArc


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawarc(inconstpen_inconstrectf__inreal_inreal)">DrawArc Methods</a>



### -field EmfPlusRecordTypeFillRegion


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillregion">Graphics::FillRegion</a>



### -field EmfPlusRecordTypeFillPath


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillpath">Graphics::FillPath</a>



### -field EmfPlusRecordTypeDrawPath


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawpath">Graphics::DrawPath</a>



### -field EmfPlusRecordTypeFillClosedCurve


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-fillclosedcurve(inconstbrush_inconstpointf_inint_infillmode_inreal)">FillClosedCurve Methods</a>



### -field EmfPlusRecordTypeDrawClosedCurve


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawclosedcurve(inconstpen_inconstpointf_inint_inreal)">DrawClosedCurve Methods</a>



### -field EmfPlusRecordTypeDrawCurve


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawcurve(inconstpen_inconstpointf_inint_inint_inint_inreal)">DrawCurve Methods</a>



### -field EmfPlusRecordTypeDrawBeziers


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawbeziers(inconstpen_inconstpoint_inint)">DrawBeziers Methods</a>



### -field EmfPlusRecordTypeDrawImage


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawimage(inimage_inconstpointf_inint)">DrawImage Methods</a> (all methods that do not receive an array of destination points)


### -field EmfPlusRecordTypeDrawImagePoints


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawimage(inimage_inconstpointf_inint)">DrawImage Methods</a> (all methods that receive an array of destination points)


### -field EmfPlusRecordTypeDrawString


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawstring(constwchar_int_constfont_constpointf__constbrush)">DrawString Methods</a>



### -field EmfPlusRecordTypeSetRenderingOrigin


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setrenderingorigin">Graphics::SetRenderingOrigin</a>



### -field EmfPlusRecordTypeSetAntiAliasMode


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setsmoothingmode">Graphics::SetSmoothingMode</a>



### -field EmfPlusRecordTypeSetTextRenderingHint


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-settextrenderinghint">Graphics::SetTextRenderingHint</a>



### -field EmfPlusRecordTypeSetTextContrast


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-settextcontrast">Graphics::SetTextContrast</a>



### -field EmfPlusRecordTypeSetInterpolationMode


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setinterpolationmode">Graphics::SetInterpolationMode</a>



### -field EmfPlusRecordTypeSetPixelOffsetMode


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setpixeloffsetmode">Graphics::SetPixelOffsetMode</a>



### -field EmfPlusRecordTypeSetCompositingMode


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setcompositingmode">Graphics::SetCompositingMode</a>



### -field EmfPlusRecordTypeSetCompositingQuality


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setcompositingquality">Graphics::SetCompositingQuality</a>



### -field EmfPlusRecordTypeSave


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-save">Graphics::Save</a>



### -field EmfPlusRecordTypeRestore


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-restore">Graphics::Restore</a>



### -field EmfPlusRecordTypeBeginContainer


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-begincontainer(inconstrect__inconstrect__inunit)">Graphics::BeginContainer</a>



### -field EmfPlusRecordTypeBeginContainerNoParams


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-begincontainer(inconstrect__inconstrect__inunit)">Graphics::BeginContainer</a>



### -field EmfPlusRecordTypeEndContainer


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-endcontainer">Graphics::EndContainer</a>



### -field EmfPlusRecordTypeSetWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-settransform">Graphics::SetTransform</a>



### -field EmfPlusRecordTypeResetWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-resettransform">Graphics::ResetTransform</a>



### -field EmfPlusRecordTypeMultiplyWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-multiplytransform">Graphics::MultiplyTransform</a>



### -field EmfPlusRecordTypeTranslateWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-translatetransform">Graphics::TranslateTransform</a>



### -field EmfPlusRecordTypeScaleWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-scaletransform">Graphics::ScaleTransform</a>



### -field EmfPlusRecordTypeRotateWorldTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-rotatetransform">Graphics::RotateTransform</a>



### -field EmfPlusRecordTypeSetPageTransform


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setpagescale">Graphics::SetPageScale</a> and <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setpageunit">Graphics::SetPageUnit</a>



### -field EmfPlusRecordTypeResetClip


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-resetclip">Graphics::ResetClip</a>



### -field EmfPlusRecordTypeSetClipRect


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setclip(inconstrect__incombinemode)">Graphics::SetClip</a> and <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setclip(inconstrectf__incombinemode)">Graphics::SetClip</a>



### -field EmfPlusRecordTypeSetClipPath


<a href="https://docs.microsoft.com/previous-versions/ms535824(v=vs.85)">Graphics::SetClip</a>



### -field EmfPlusRecordTypeSetClipRegion


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-setclip(inhrgn_incombinemode)">Graphics::SetClip</a>



### -field EmfPlusRecordTypeOffsetClip


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-translateclip(inint_inint)">TranslateClip Methods</a>



### -field EmfPlusRecordTypeDrawDriverString


<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusgraphics/nf-gdiplusgraphics-graphics-drawdriverstring">Graphics::DrawDriverString</a>



### -field EmfPlusRecordTypeStrokeFillPath


### -field EmfPlusRecordTypeSerializableObject


### -field EmfPlusRecordTypeSetTSGraphics


### -field EmfPlusRecordTypeSetTSClip


### -field EmfPlusRecordTotal


### -field EmfPlusRecordTypeMax


### -field EmfPlusRecordTypeMin


#### - EmfPlusRecordTypeSetGammaValue

