---
UID: NE:gdiplusenums.EncoderValue
title: EncoderValue (gdiplusenums.h)
description: The EncoderValue enumeration specifies values that can be passed as arguments to image encoders. For more information about image encoders, see Using Image Encoders and Decoders .
old-location: gdiplus\_gdiplus_ENUM_EncoderValue.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\encodervalue.htm
ms.date: 12/05/2018
ms.keywords: EncoderValue, EncoderValue enumeration [GDI+], EncoderValueColorTypeCMYK, EncoderValueColorTypeYCCK, EncoderValueCompressionCCITT3, EncoderValueCompressionCCITT4, EncoderValueCompressionLZW, EncoderValueCompressionNone, EncoderValueCompressionRle, EncoderValueFlush, EncoderValueFrameDimensionPage, EncoderValueFrameDimensionResolution, EncoderValueFrameDimensionTime, EncoderValueLastFrame, EncoderValueMultiFrame, EncoderValueRenderNonProgressive, EncoderValueRenderProgressive, EncoderValueScanMethodInterlaced, EncoderValueScanMethodNonInterlaced, EncoderValueTransformFlipHorizontal, EncoderValueTransformFlipVertical, EncoderValueTransformRotate180, EncoderValueTransformRotate270, EncoderValueTransformRotate90, EncoderValueVersionGif87, EncoderValueVersionGif89, _gdiplus_ENUM_EncoderValue, gdiplus._gdiplus_ENUM_EncoderValue, gdiplusenums/EncoderValue, gdiplusenums/EncoderValueColorTypeCMYK, gdiplusenums/EncoderValueColorTypeYCCK, gdiplusenums/EncoderValueCompressionCCITT3, gdiplusenums/EncoderValueCompressionCCITT4, gdiplusenums/EncoderValueCompressionLZW, gdiplusenums/EncoderValueCompressionNone, gdiplusenums/EncoderValueCompressionRle, gdiplusenums/EncoderValueFlush, gdiplusenums/EncoderValueFrameDimensionPage, gdiplusenums/EncoderValueFrameDimensionResolution, gdiplusenums/EncoderValueFrameDimensionTime, gdiplusenums/EncoderValueLastFrame, gdiplusenums/EncoderValueMultiFrame, gdiplusenums/EncoderValueRenderNonProgressive, gdiplusenums/EncoderValueRenderProgressive, gdiplusenums/EncoderValueScanMethodInterlaced, gdiplusenums/EncoderValueScanMethodNonInterlaced, gdiplusenums/EncoderValueTransformFlipHorizontal, gdiplusenums/EncoderValueTransformFlipVertical, gdiplusenums/EncoderValueTransformRotate180, gdiplusenums/EncoderValueTransformRotate270, gdiplusenums/EncoderValueTransformRotate90, gdiplusenums/EncoderValueVersionGif87, gdiplusenums/EncoderValueVersionGif89
f1_keywords:
- gdiplusenums/EncoderValue
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- EncoderValue
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# EncoderValue enumeration


## -description


The <b>EncoderValue</b> enumeration specifies values that can be passed as arguments to image encoders. For more information about image encoders, see <a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-image-encoders-and-decoders-use">Using Image Encoders and Decoders</a> .


## -enum-fields




### -field EncoderValueColorTypeCMYK

Not used in GDI+ version 1.0. 


### -field EncoderValueColorTypeYCCK

Not used in GDI+ version 1.0. 


### -field EncoderValueCompressionLZW

For a TIFF image, specifies the LZW compression method. 


### -field EncoderValueCompressionCCITT3

For a TIFF image, specifies the CCITT3 compression method. 


### -field EncoderValueCompressionCCITT4

For a TIFF image, specifies the CCITT4 compression method. 


### -field EncoderValueCompressionRle

For a TIFF image, specifies the RLE compression method. 


### -field EncoderValueCompressionNone

For a TIFF image, specifies no compression. 


### -field EncoderValueScanMethodInterlaced

Not used in GDI+ version 1.0. 


### -field EncoderValueScanMethodNonInterlaced

Not used in GDI+ version 1.0. 


### -field EncoderValueVersionGif87

Not used in GDI+ version 1.0. 


### -field EncoderValueVersionGif89

Not used in GDI+ version 1.0. 


### -field EncoderValueRenderProgressive

Not used in GDI+ version 1.0. 


### -field EncoderValueRenderNonProgressive

Not used in GDI+ version 1.0. 


### -field EncoderValueTransformRotate90

For a JPEG image, specifies lossless 90-degree clockwise rotation. 


### -field EncoderValueTransformRotate180

For a JPEG image, specifies lossless 180-degree rotation. 


### -field EncoderValueTransformRotate270

For a JPEG image, specifies lossless 270-degree clockwise rotation. 


### -field EncoderValueTransformFlipHorizontal

For a JPEG image, specifies a lossless horizontal flip. 


### -field EncoderValueTransformFlipVertical

For a JPEG image, specifies a lossless vertical flip. 


### -field EncoderValueMultiFrame

Specifies multiple-frame encoding. 


### -field EncoderValueLastFrame

Specifies the last frame of a multiple-frame image. 


### -field EncoderValueFlush

Specifies that the encoder object is to be closed. 


### -field EncoderValueFrameDimensionTime

Not used in GDI+ version 1.0. 


### -field EncoderValueFrameDimensionResolution

Not used in GDI+ version 1.0. 


### -field EncoderValueFrameDimensionPage

For a TIFF image, specifies the page frame dimension 


### -field EncoderValueColorTypeGray


### -field EncoderValueColorTypeRGB



