---
UID: NE:gdiplusenums.FontStyle
title: FontStyle (gdiplusenums.h)
description: The FontStyle enumeration specifies the style of the typeface of a font. Styles can be combined.
old-location: gdiplus\_gdiplus_ENUM_FontStyle.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\fontstyle.htm
ms.date: 12/05/2018
ms.keywords: FontStyle, FontStyle enumeration [GDI+], FontStyleBold, FontStyleBoldItalic, FontStyleItalic, FontStyleRegular, FontStyleStrikeout, FontStyleUnderline, _gdiplus_ENUM_FontStyle, gdiplus._gdiplus_ENUM_FontStyle, gdiplusenums/FontStyle, gdiplusenums/FontStyleBold, gdiplusenums/FontStyleBoldItalic, gdiplusenums/FontStyleItalic, gdiplusenums/FontStyleRegular, gdiplusenums/FontStyleStrikeout, gdiplusenums/FontStyleUnderline
f1_keywords:
- gdiplusenums/FontStyle
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- FontStyle
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# FontStyle enumeration


## -description


The <b>FontStyle</b> enumeration specifies the style of the typeface of a font. Styles can be combined.


## -enum-fields




### -field FontStyleRegular

Specifies normal weight or thickness of the typeface. 


### -field FontStyleBold

Specifies bold typeface. Bold is a heavier weight or thickness. 


### -field FontStyleItalic

Specifies italic typeface, which produces a noticeable slant to the vertical stems of the characters. 


### -field FontStyleBoldItalic

Specifies the typeface as both bold and italic. 


### -field FontStyleUnderline

Specifies underline, which displays a line underneath the baseline of the characters. 


### -field FontStyleStrikeout

Specifies strikeout, which displays a horizontal line drawn through the middle of the characters. 

