---
UID: NE:gdiplusenums.HatchStyle
title: HatchStyle (gdiplusenums.h)
description: The HatchStyle enumeration specifies the hatch pattern used by a brush of type HatchBrush. The hatch pattern consists of a solid background color and lines drawn over the background.
old-location: gdiplus\_gdiplus_ENUM_HatchStyle.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\hatchstyle.htm
ms.date: 12/05/2018
ms.keywords: HatchStyle, HatchStyle enumeration [GDI+], HatchStyle05Percent, HatchStyle10Percent, HatchStyle20Percent, HatchStyle25Percent, HatchStyle30Percent, HatchStyle40Percent, HatchStyle50Percent, HatchStyle60Percent, HatchStyle70Percent, HatchStyle75Percent, HatchStyle80Percent, HatchStyle90Percent, HatchStyleBackwardDiagonal, HatchStyleCross, HatchStyleDarkDownwardDiagonal, HatchStyleDarkHorizontal, HatchStyleDarkUpwardDiagonal, HatchStyleDarkVertical, HatchStyleDashedDownwardDiagonal, HatchStyleDashedHorizontal, HatchStyleDashedUpwardDiagonal, HatchStyleDashedVertical, HatchStyleDiagonalBrick, HatchStyleDiagonalCross, HatchStyleDivot, HatchStyleDottedDiamond, HatchStyleDottedGrid, HatchStyleForwardDiagonal, HatchStyleHorizontal, HatchStyleHorizontalBrick, HatchStyleLargeCheckerBoard, HatchStyleLargeConfetti, HatchStyleLargeGrid, HatchStyleLightDownwardDiagonal, HatchStyleLightHorizontal, HatchStyleLightUpwardDiagonal, HatchStyleLightVertical, HatchStyleMax, HatchStyleMin, HatchStyleNarrowHorizontal, HatchStyleNarrowVertical, HatchStyleOutlinedDiamond, HatchStylePlaid, HatchStyleShingle, HatchStyleSmallCheckerBoard, HatchStyleSmallConfetti, HatchStyleSmallGrid, HatchStyleSolidDiamond, HatchStyleSphere, HatchStyleTotal, HatchStyleTrellis, HatchStyleVertical, HatchStyleWave, HatchStyleWeave, HatchStyleWideDownwardDiagonal, HatchStyleWideUpwardDiagonal, HatchStyleZigZag, _gdiplus_ENUM_HatchStyle, gdiplus._gdiplus_ENUM_HatchStyle, gdiplusenums/HatchStyle, gdiplusenums/HatchStyle05Percent, gdiplusenums/HatchStyle10Percent, gdiplusenums/HatchStyle20Percent, gdiplusenums/HatchStyle25Percent, gdiplusenums/HatchStyle30Percent, gdiplusenums/HatchStyle40Percent, gdiplusenums/HatchStyle50Percent, gdiplusenums/HatchStyle60Percent, gdiplusenums/HatchStyle70Percent, gdiplusenums/HatchStyle75Percent, gdiplusenums/HatchStyle80Percent, gdiplusenums/HatchStyle90Percent, gdiplusenums/HatchStyleBackwardDiagonal, gdiplusenums/HatchStyleCross, gdiplusenums/HatchStyleDarkDownwardDiagonal, gdiplusenums/HatchStyleDarkHorizontal, gdiplusenums/HatchStyleDarkUpwardDiagonal, gdiplusenums/HatchStyleDarkVertical, gdiplusenums/HatchStyleDashedDownwardDiagonal, gdiplusenums/HatchStyleDashedHorizontal, gdiplusenums/HatchStyleDashedUpwardDiagonal, gdiplusenums/HatchStyleDashedVertical, gdiplusenums/HatchStyleDiagonalBrick, gdiplusenums/HatchStyleDiagonalCross, gdiplusenums/HatchStyleDivot, gdiplusenums/HatchStyleDottedDiamond, gdiplusenums/HatchStyleDottedGrid, gdiplusenums/HatchStyleForwardDiagonal, gdiplusenums/HatchStyleHorizontal, gdiplusenums/HatchStyleHorizontalBrick, gdiplusenums/HatchStyleLargeCheckerBoard, gdiplusenums/HatchStyleLargeConfetti, gdiplusenums/HatchStyleLargeGrid, gdiplusenums/HatchStyleLightDownwardDiagonal, gdiplusenums/HatchStyleLightHorizontal, gdiplusenums/HatchStyleLightUpwardDiagonal, gdiplusenums/HatchStyleLightVertical, gdiplusenums/HatchStyleMax, gdiplusenums/HatchStyleMin, gdiplusenums/HatchStyleNarrowHorizontal, gdiplusenums/HatchStyleNarrowVertical, gdiplusenums/HatchStyleOutlinedDiamond, gdiplusenums/HatchStylePlaid, gdiplusenums/HatchStyleShingle, gdiplusenums/HatchStyleSmallCheckerBoard, gdiplusenums/HatchStyleSmallConfetti, gdiplusenums/HatchStyleSmallGrid, gdiplusenums/HatchStyleSolidDiamond, gdiplusenums/HatchStyleSphere, gdiplusenums/HatchStyleTotal, gdiplusenums/HatchStyleTrellis, gdiplusenums/HatchStyleVertical, gdiplusenums/HatchStyleWave, gdiplusenums/HatchStyleWeave, gdiplusenums/HatchStyleWideDownwardDiagonal, gdiplusenums/HatchStyleWideUpwardDiagonal, gdiplusenums/HatchStyleZigZag
f1_keywords:
- gdiplusenums/HatchStyle
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- HatchStyle
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# HatchStyle enumeration


## -description


The <b>HatchStyle</b> enumeration specifies the hatch pattern used by a brush of type 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusbrush/nl-gdiplusbrush-hatchbrush">HatchBrush</a>. The hatch pattern consists of a solid background color and lines drawn over the background. 


## -enum-fields




### -field HatchStyleHorizontal

Specifies horizontal lines. 
				



<img alt="Illustration of an ellipse filled with widely spaced horizontal lines over a background color" src="./images/hatchstylehorizontal.png"/>


### -field HatchStyleVertical

Specifies vertical lines. 
				

<img alt="Illustration of an ellipse filled with widely spaced vertical lines over a background color" src="./images/hatchstylevertical.png"/>


### -field HatchStyleForwardDiagonal

Specifies diagonal lines that slant to the right from top points to bottom points. The lines are antialiased. 
				

<img alt="Illustration of an ellipse filled with slanting lines over a background color" src="./images/hatchstyleforwarddiagonal.png"/>


### -field HatchStyleBackwardDiagonal

Specifies diagonal lines that slant to the left from top points to bottom points. The lines are antialiased. 
				

<img alt="Illustration of an ellipse filled with slanting lines over a background color" src="./images/hatchstylebackwarddiagonal.png"/>


### -field HatchStyleCross

Specifies horizontal and vertical lines that cross at 90-degree angles. 
				

<img alt="Illustration of an ellipse filled with a grid of horizontal and vertical lines over a background color" src="./images/hatchstylecross.png"/>


### -field HatchStyleDiagonalCross

Specifies forward diagonal and backward diagonal lines that cross at 90-degree angles. The lines are antialiased. 
				

<img alt="Illustration of an ellipse filled with a grid of diagonal lines over a background color" src="./images/hatchstylediagonalcross.png"/>


### -field HatchStyle05Percent

Specifies a 5-percent hatch. The ratio of foreground color to background color is 5:100. 
				

<img alt="Illustration of an ellipse filled with sparse, evenly spaced dots over a background color" src="./images/hatchstyle05percent.png"/>


### -field HatchStyle10Percent

Specifies a 10-percent hatch. The ratio of foreground color to background color is 10:100. 
				

<img alt="Illustration of an ellipse filled with evenly spaced dots over a background color" src="./images/hatchstyle10percent.png"/>


### -field HatchStyle20Percent

Specifies a 20-percent hatch. The ratio of foreground color to background color is 20:100. 
				

<img alt="Illustration of an ellipse filled with dense, evenly spaced dots over a background color" src="./images/hatchstyle20percent.png"/>


### -field HatchStyle25Percent

Specifies a 25-percent hatch. The ratio of foreground color to background color is 25:100. 
				

<img alt="Illustration of an ellipse filled with very dense, evenly spaced dots over a background color" src="./images/hatchstyle25percent.png"/>


### -field HatchStyle30Percent

Specifies a 30-percent hatch. The ratio of foreground color to background color is 30:100. 
				

<img alt="Illustration of an ellipse filled with a dense, diagonal dot grid over a background color" src="./images/hatchstyle30percent.png"/>


### -field HatchStyle40Percent

Specifies a 40-percent hatch. The ratio of foreground color to background color is 40:100. 
				

<img alt="Illustration of an ellipse filled with tiny checkerboard with cutouts shaped like plus signs, over a background color" src="./images/hatchstyle40percent.png"/>


### -field HatchStyle50Percent

Specifies a 50-percent hatch. The ratio of foreground color to background color is 50:100. 
				

<img alt="Illustration of an ellipse filled with a tiny checkerboard over a background color" src="./images/hatchstyle50percent.png"/>


### -field HatchStyle60Percent

Specifies a 60-percent hatch. The ratio of foreground color to background color is 60:100. 
				

<img alt="Illustration of an ellipse filled with a diagonal grid of plus-signs over a background color" src="./images/hatchstyle60percent.png"/>


### -field HatchStyle70Percent

Specifies a 70-percent hatch. The ratio of foreground color to background color is 70:100. 
				

<img alt="Illustration of an ellipse filled with a dense, diagonal dot grid over a background color" src="./images/hatchstyle70percent.png"/>


### -field HatchStyle75Percent

Specifies a 75-percent hatch. The ratio of foreground color to background color is 75:100. 
				

<img alt="Illustration of an ellipse filled with a wide, diagonal grid over a background color" src="./images/hatchstyle75percent.png"/>


### -field HatchStyle80Percent

Specifies an 80-percent hatch. The ratio of foreground color to background color is 80:100. 
				

<img alt="Illustration of an ellipse filled with a wider, diagonal grid over a background color" src="./images/hatchstyle80percent.png"/>


### -field HatchStyle90Percent

Specifies a 90-percent hatch. The ratio of foreground color to background color is 90:100. 
				

<img alt="Illustration of an ellipse filled with the widest, diagonal grid over a background color" src="./images/hatchstyle90percent.png"/>


### -field HatchStyleLightDownwardDiagonal

Specifies diagonal lines that slant to the right from top points to bottom points and are spaced 50 percent closer together than HatchStyleForwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with slanting lines over a background color" src="./images/hatchstylelightdownwarddiagonal.png"/>


### -field HatchStyleLightUpwardDiagonal

Specifies diagonal lines that slant to the left from top points to bottom points and are spaced 50 percent closer together than HatchStyleBackwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with slanting lines over a background color " src="./images/hatchstylelightupwarddiagonal.png"/>


### -field HatchStyleDarkDownwardDiagonal

Specifies diagonal lines that slant to the right from top points to bottom points, are spaced 50 percent closer together than HatchStyleForwardDiagonal, and are twice the width of HatchStyleForwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with wide, slanting lines over a background color " src="./images/hatchstyledarkdownwarddiagonal.png"/>


### -field HatchStyleDarkUpwardDiagonal

Specifies diagonal lines that slant to the left from top points to bottom points, are spaced 50 percent closer together than HatchStyleBackwardDiagonal, and are twice the width of HatchStyleBackwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with wide, slanting lines over a background color" src="./images/hatchstyledarkupwarddiagonal.png"/>


### -field HatchStyleWideDownwardDiagonal

Specifies diagonal lines that slant to the right from top points to bottom points, have the same spacing as HatchStyleForwardDiagonal, and are triple the width of HatchStyleForwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with wide, widely-spaced, slanting lines over a background color" src="./images/hatchstylewidedownwarddiagonal.png"/>


### -field HatchStyleWideUpwardDiagonal

Specifies diagonal lines that slant to the left from top points to bottom points, have the same spacing as HatchStyleBackwardDiagonal, and are triple the width of HatchStyleBackwardDiagonal but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with widely-spaced, wide, slanting lines over a background color " src="./images/hatchstylewideupwarddiagonal.png"/>


### -field HatchStyleLightVertical

Specifies vertical lines that are spaced 50 percent closer together than HatchStyleVertical. 
				

<img alt="Illustration of an ellipse filled with vertical lines over a background color " src="./images/hatchstylelightvertical.png"/>


### -field HatchStyleLightHorizontal

Specifies horizontal lines that are spaced 50 percent closer together than HatchStyleHorizontal. 
				

<img alt="Illustration of an ellipse filled with horizontal lines over a background color " src="./images/hatchstylelighthorizontal.png"/>


### -field HatchStyleNarrowVertical

Specifies vertical lines that are spaced 75 percent closer together than HatchStyleVertical (or 25 percent closer together than HatchStyleLightVertical). 
				

<img alt="Illustration of an ellipse filled with densely-spaced, vertical lines over a background color " src="./images/hatchstylenarrowvertical.png"/>


### -field HatchStyleNarrowHorizontal

Specifies horizontal lines that are spaced 75 percent closer together than HatchStyleHorizontal ( or 25 percent closer together than HatchStyleLightHorizontal). 
				

<img alt="Illustration of an ellipse filled with densely-spaced, horizontal lines over a background color " src="./images/hatchstylenarrowhorizontal.png"/>


### -field HatchStyleDarkVertical

Specifies vertical lines that are spaced 50 percent closer together than HatchStyleVerical and are twice the width of HatchStyleVertical. 
				

<img alt="Illustration of an ellipse filled with wide vertical lines over a background color " src="./images/hatchstyledarkvertical.png"/>


### -field HatchStyleDarkHorizontal

Specifies horizontal lines that are spaced 50 percent closer together than HatchStyleHorizontal and are twice the width of HatchStyleHorizontal. 
				

<img alt="Illustration of an ellipse filled with wide horizontal lines over a background color " src="./images/hatchstyledarkhorizontal.png"/>


### -field HatchStyleDashedDownwardDiagonal

Specifies horizontal lines that are composed of forward diagonals. 
				

<img alt="Illustration of an ellipse filled with rows of slash characters over a background color " src="./images/hatchstyledasheddownwarddiagonal.png"/>


### -field HatchStyleDashedUpwardDiagonal

Specifies horizontal lines that are composed of backward diagonals. 
				

<img alt="Illustration of an ellipse filled with rows of backslash characters over a background color " src="./images/hatchstyledashedupwarddiagonal.png"/>


### -field HatchStyleDashedHorizontal

Specifies horizontal dashed lines. 
				

<img alt="Illustration of an ellipse filled with dashed horizontal lines over a background color " src="./images/hatchstyledashedhorizontal.png"/>


### -field HatchStyleDashedVertical

Specifies vertical dashed lines. 
				

<img alt="Illustration of an ellipse filled with dashed vertical lines over a background color " src="./images/hatchstyledashedvertical.png"/>


### -field HatchStyleSmallConfetti

Specifies a hatch that has the appearance of confetti. 
				

<img alt="Illustration of an ellipse filled with dots that form horizontal zig-zag lines, over a background color " src="./images/hatchstylesmallconfetti.png"/>


### -field HatchStyleLargeConfetti

Specifies a hatch that has the appearance of confetti composed of larger pieces than HatchStyleSmallConfetti. 
				

<img alt="Illustration of an ellipse filled with wider dots in an irregular but repeating pattern, over a background color " src="./images/hatchstylelargeconfetti.png"/>


### -field HatchStyleZigZag

Specifies horizontal lines of zigzags. 
				

<img alt="Illustration of an ellipse filled with horizontal zig-zag lines over a background color " src="./images/hatchstylezigzag.png"/>


### -field HatchStyleWave

Specifies horizontal lines of tildes. 
				

<img alt="Illustration of an ellipse filled with lines of tilde characters over a background color " src="./images/hatchstylewave.png"/>


### -field HatchStyleDiagonalBrick

Specifies a hatch that has the appearance of a wall of bricks laid in a backward diagonal direction. 
				

<img alt="Illustration of an ellipse filled with a diagonal brick pattern over a background color " src="./images/hatchstylediagonalbrick.png"/>


### -field HatchStyleHorizontalBrick

Specifies a hatch that has the appearance of a wall of bricks laid horizontally. 
				

<img alt="Illustration of an ellipse filled with a horizontal brick pattern over a background color " src="./images/hatchstylehorizontalbrick.png"/>


### -field HatchStyleWeave

Specifies a hatch that has the appearance of a woven material. 
				

<img alt="Illustration of an ellipse filled with a diagonal weave pattern over a background color " src="./images/hatchstyleweave.png"/>


### -field HatchStylePlaid

Specifies a hatch that has the appearance of a plaid material. 
				

<img alt="Illustration of an ellipse filled with an open grid of opaque half-toned horizontal lines over opaque solid vertical lines, over a background color " src="./images/hatchstyleplaid.png"/>


### -field HatchStyleDivot

Specifies a hatch that has the appearance of divots. 
				

<img alt="Illustration of an ellipse filled with alternating rows of greater-than and less-than symbols, over a background color" src="./images/hatchstyledivot.png"/>


### -field HatchStyleDottedGrid

Specifies horizontal and vertical dotted lines that cross at 90-degree angles. 
				

<img alt="Illustration of an ellipse filled with a grid of dotted lines over a background color " src="./images/hatchstyledottedgrid.png"/>


### -field HatchStyleDottedDiamond

Specifies forward diagonal and backward diagonal dotted lines that cross at 90-degree angles. 
				

<img alt="Illustration of an ellipse filled with a grid of slanting dotted lines over a background color " src="./images/hatchstyledotteddiamond.png"/>


### -field HatchStyleShingle

Specifies a hatch that has the appearance of shingles laid in a forward diagonal direction. 
				

<img alt="Illustration of an ellipse filled with a diagonal shingle pattern over a background color " src="./images/hatchstyleshingle.png"/>


### -field HatchStyleTrellis

Specifies a hatch that has the appearance of a trellis. 
				

<img alt="Illustration of an ellipse filled with a grid of wide, slanting lines over a background color " src="./images/hatchstyletrellis.png"/>


### -field HatchStyleSphere

Specifies a hatch that has the appearance of a checkerboard of spheres. 
				

<img alt="Illustration of an ellipse filled with a checkerboard of spheres over a background color " src="./images/hatchstylesphere.png"/>


### -field HatchStyleSmallGrid

Specifies horizontal and vertical lines that cross at 90-degree angles and are spaced 50 percent closer together than HatchStyleCross. 
				

<img alt="Illustration of an ellipse filled with a small grid of lines over a background color " src="./images/hatchstylesmallgrid.png"/>


### -field HatchStyleSmallCheckerBoard

Specifies a hatch that has the appearance of a checkerboard. 
				

<img alt="Illustration of an ellipse filled with a small checkerboard pattern over a background color " src="./images/hatchstylesmallcheckerboard.png"/>


### -field HatchStyleLargeCheckerBoard

Specifies a hatch that has the appearance of a checkerboard with squares that are twice the size of HatchStyleSmallCheckerBoard. 
				

<img alt="Illustration of an ellipse filled with a wide checkerboard pattern over a background color " src="./images/hatchstylelargecheckerboard.png"/>


### -field HatchStyleOutlinedDiamond

Specifies forward diagonal and backward diagonal lines that cross at 90-degree angles but are not antialiased. 
				

<img alt="Illustration of an ellipse filled with a small grid of slanting lines over a background color " src="./images/hatchstyleoutlineddiamond.png"/>


### -field HatchStyleSolidDiamond

Specifies a hatch that has the appearance of a checkerboard placed diagonally. 
				

<img alt="Illustration of an ellipse filled with a large, diagonal checkerboard pattern over a background color " src="./images/hatchstylesoliddiamond.png"/>


### -field HatchStyleTotal

Specifies no hatch thereby allowing the brush to be transparent. 


### -field HatchStyleLargeGrid

Specifies HatchStyleCross. 


### -field HatchStyleMin

Specifies HatchStyleHorizonal. 


### -field HatchStyleMax

Specifies HatchStyleSolidDiamond. 

