---
UID: NE:gdiplusenums.LinearGradientMode
title: LinearGradientMode (gdiplusenums.h)
description: The LinearGradientMode enumeration specifies the direction in which the change of color occurs for a linear gradient brush.
old-location: gdiplus\_gdiplus_ENUM_LinearGradientMode.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\lineargradientmode.htm
ms.date: 12/05/2018
ms.keywords: LinearGradientMode, LinearGradientMode enumeration [GDI+], LinearGradientModeBackwardDiagonal, LinearGradientModeForwardDiagonal, LinearGradientModeHorizontal, LinearGradientModeVertical, _gdiplus_ENUM_LinearGradientMode, gdiplus._gdiplus_ENUM_LinearGradientMode, gdiplusenums/LinearGradientMode, gdiplusenums/LinearGradientModeBackwardDiagonal, gdiplusenums/LinearGradientModeForwardDiagonal, gdiplusenums/LinearGradientModeHorizontal, gdiplusenums/LinearGradientModeVertical
f1_keywords:
- gdiplusenums/LinearGradientMode
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- LinearGradientMode
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# LinearGradientMode enumeration


## -description


The <b>LinearGradientMode</b> enumeration specifies the direction in which the change of color occurs for a linear gradient brush.


## -enum-fields




### -field LinearGradientModeHorizontal

Specifies the color to change in a horizontal direction from the left of the display to the right of the display. 


### -field LinearGradientModeVertical

Specifies the color to change in a vertical direction from the top of the display to the bottom of the display. 


### -field LinearGradientModeForwardDiagonal

Specifies the color to change in a forward diagonal direction from the upper-left corner to the lower-right corner of the display. 


### -field LinearGradientModeBackwardDiagonal

Specifies the color to change in a backward diagonal direction from the upper-right corner to the lower-left corner of the display. 

