---
UID: NE:gdiplusenums.MatrixOrder
title: MatrixOrder (gdiplusenums.h)
description: The MatrixOrder enumeration specifies the order of multiplication when a new matrix is multiplied by an existing matrix.
old-location: gdiplus\_gdiplus_ENUM_MatrixOrder.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\matrixorder.htm
ms.date: 12/05/2018
ms.keywords: MatrixOrder, MatrixOrder enumeration [GDI+], MatrixOrderAppend, MatrixOrderPrepend, _gdiplus_ENUM_MatrixOrder, gdiplus._gdiplus_ENUM_MatrixOrder, gdiplusenums/MatrixOrder, gdiplusenums/MatrixOrderAppend, gdiplusenums/MatrixOrderPrepend
f1_keywords:
- gdiplusenums/MatrixOrder
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- MatrixOrder
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# MatrixOrder enumeration


## -description


The <b>MatrixOrder</b> enumeration specifies the order of multiplication when a new matrix is multiplied by an existing matrix. 


## -enum-fields




### -field MatrixOrderPrepend

Specifies that the new matrix is on the left and the existing matrix is on the right. 


### -field MatrixOrderAppend

Specifies that the existing matrix is on the left and the new matrix is on the right. 

