---
UID: NE:gdiplusenums.MetafileFrameUnit
title: MetafileFrameUnit (gdiplusenums.h)
description: The MetafileFrameUnit enumeration specifies the unit of measure for a metafile frame rectangle.
old-location: gdiplus\_gdiplus_ENUM_MetafileFrameUnit.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\metafileframeunit.htm
ms.date: 12/05/2018
ms.keywords: MetafileFrameUnit, MetafileFrameUnit enumeration [GDI+], MetafileFrameUnitDocument, MetafileFrameUnitGdi, MetafileFrameUnitInch, MetafileFrameUnitMillimeter, MetafileFrameUnitPixel, MetafileFrameUnitPoint, _gdiplus_ENUM_MetafileFrameUnit, gdiplus._gdiplus_ENUM_MetafileFrameUnit, gdiplusenums/MetafileFrameUnit, gdiplusenums/MetafileFrameUnitDocument, gdiplusenums/MetafileFrameUnitGdi, gdiplusenums/MetafileFrameUnitInch, gdiplusenums/MetafileFrameUnitMillimeter, gdiplusenums/MetafileFrameUnitPixel, gdiplusenums/MetafileFrameUnitPoint
f1_keywords:
- gdiplusenums/MetafileFrameUnit
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- MetafileFrameUnit
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# MetafileFrameUnit enumeration


## -description


The <b>MetafileFrameUnit</b> enumeration specifies the unit of measure for a metafile frame rectangle. 


## -enum-fields




### -field MetafileFrameUnitPixel

Specifies that a unit is 1 pixel. 


### -field MetafileFrameUnitPoint

Specifies that a unit is 1 point. 


### -field MetafileFrameUnitInch

Specifies that a unit is 1 inch. 


### -field MetafileFrameUnitDocument

Specifies that a unit is 1/300 inch. 


### -field MetafileFrameUnitMillimeter

Specifies that a unit is 1 millimeter. 


### -field MetafileFrameUnitGdi

Specifies that a unit is 0.01 millimeter. This element is provided for compatibility with GDI. 

