---
UID: NE:gdiplusenums.Unit
title: Unit (gdiplusenums.h)
description: The Unit enumeration specifies the unit of measure for a given data type.
old-location: gdiplus\_gdiplus_ENUM_Unit.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\enumerations\unit.htm
ms.date: 12/05/2018
ms.keywords: Unit, Unit enumeration [GDI+], UnitDisplay, UnitDocument, UnitInch, UnitMillimeter, UnitPixel, UnitPoint, UnitWorld, _gdiplus_ENUM_Unit, gdiplus._gdiplus_ENUM_Unit, gdiplusenums/Unit, gdiplusenums/UnitDisplay, gdiplusenums/UnitDocument, gdiplusenums/UnitInch, gdiplusenums/UnitMillimeter, gdiplusenums/UnitPixel, gdiplusenums/UnitPoint, gdiplusenums/UnitWorld
f1_keywords:
- gdiplusenums/Unit
dev_langs:
- c++
req.header: gdiplusenums.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusenums.h
api_name:
- Unit
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Unit enumeration


## -description


The <b>Unit</b> enumeration specifies the unit of measure for a given data type.


## -enum-fields




### -field UnitWorld

Specifies world coordinates, a nonphysical unit. 


### -field UnitDisplay

Specifies display units. For example, if the display device is a monitor, then the unit is 1 pixel. 


### -field UnitPixel

Specifies that a unit is 1 pixel. 


### -field UnitPoint

Specifies that a unit is 1 point or 1/72 inch. 


### -field UnitInch

Specifies that a unit is 1 inch. 


### -field UnitDocument

Specifies that a unit is 1/300 inch. 


### -field UnitMillimeter

Specifies that a unit is 1 millimeter. 

