---
UID: NF:gdiplusheaders.Bitmap.SetResolution
title: Bitmap::SetResolution (gdiplusheaders.h)
description: The Bitmap::SetResolution method sets the resolution of this Bitmap object.
old-location: gdiplus\_gdiplus_CLASS_Bitmap_SetResolution_xdpi_ydpi_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\bitmapclass\bitmapmethods\setresolution.htm
ms.date: 12/05/2018
ms.keywords: Bitmap class [GDI+],SetResolution method, Bitmap.SetResolution, Bitmap::SetResolution, SetResolution, SetResolution method [GDI+], SetResolution method [GDI+],Bitmap class, _gdiplus_CLASS_Bitmap_SetResolution_xdpi_ydpi_, gdiplus._gdiplus_CLASS_Bitmap_SetResolution_xdpi_ydpi_
f1_keywords:
- gdiplusheaders/Bitmap.SetResolution
dev_langs:
- c++
req.header: gdiplusheaders.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Bitmap.SetResolution
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Bitmap::SetResolution


## -description


The <b>Bitmap::SetResolution</b> method sets the resolution of this 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-bitmap">Bitmap</a> object.


## -parameters




### -param xdpi [in]

Type: <b>REAL</b>

Real number that specifies the horizontal resolution in dots per inch. 


### -param ydpi [in]

Type: <b>REAL</b>

Real number that specifies the vertical resolution in dots per inch. 


## -returns



Type: <strong>Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/ne-gdiplustypes-status">Status</a></b>
</strong>

If the method succeeds, it returns <b>Ok</b>, which is an element of the 
						<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/ne-gdiplustypes-status">Status</a> enumeration.

If the method fails, it returns one of the other elements of the 
						<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/ne-gdiplustypes-status">Status</a> enumeration.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-bitmap">Bitmap</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-image">Image</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-images-bitmaps-and-metafiles-about">Images, Bitmaps, and Metafiles</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-images-bitmaps-and-metafiles-use">Using Images, Bitmaps, and Metafiles</a>
 

 

