---
UID: NF:gdiplusheaders.Font.GetSize
title: Font::GetSize (gdiplusheaders.h)
description: The Font::GetSize method returns the font size (commonly called the em size) of this Font object. The size is in the units of this Font object.
old-location: gdiplus\_gdiplus_CLASS_Font_GetSize_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\fontclass\fontmethods\getsize.htm
ms.date: 12/05/2018
ms.keywords: Font class [GDI+],GetSize method, Font.GetSize, Font::GetSize, GetSize, GetSize method [GDI+], GetSize method [GDI+],Font class, _gdiplus_CLASS_Font_GetSize_, gdiplus._gdiplus_CLASS_Font_GetSize_
f1_keywords:
- gdiplusheaders/Font.GetSize
dev_langs:
- c++
req.header: gdiplusheaders.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Font.GetSize
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Font::GetSize


## -description


The <b>Font::GetSize</b> method returns the font size (commonly called the em size) of this 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-font">Font</a> object. The size is in the units of this 
			<b>Font</b> object.


## -parameters






## -returns



Type: <strong>Type: <b>REAL</b>
</strong>

The method returns the font size. The size is in the units of this 
						<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-font">Font</a> object.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-font">Font</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-font-getheight(inreal)">Font::GetHeight</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-font-getstyle">Font::GetStyle</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-font-getunit">Font::GetUnit</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-text-and-fonts-use">Using Text and Fonts</a>
 

 

