---
UID: NF:gdiplusheaders.FontFamily.GenericSansSerif
title: FontFamily::GenericSansSerif (gdiplusheaders.h)
description: The FontFamily::GenericSansSerif method gets a FontFamily object that specifies a generic sans serif typeface.
old-location: gdiplus\_gdiplus_CLASS_FontFamily_GenericSansSerif_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\fontfamilyclass\fontfamilymethods\genericsansserif.htm
ms.date: 12/05/2018
ms.keywords: FontFamily class [GDI+],GenericSansSerif method, FontFamily.GenericSansSerif, FontFamily::GenericSansSerif, GenericSansSerif, GenericSansSerif method [GDI+], GenericSansSerif method [GDI+],FontFamily class, _gdiplus_CLASS_FontFamily_GenericSansSerif_, gdiplus._gdiplus_CLASS_FontFamily_GenericSansSerif_
f1_keywords:
- gdiplusheaders/FontFamily.GenericSansSerif
dev_langs:
- c++
req.header: gdiplusheaders.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- FontFamily.GenericSansSerif
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# FontFamily::GenericSansSerif


## -description


The <b>FontFamily::GenericSansSerif</b> method gets a <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-fontfamily">FontFamily</a> object that specifies a generic sans serif typeface.


## -parameters






## -returns



Type: <strong>Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-fontfamily">FontFamily</a>*</b>
</strong>

This method returns a pointer to a <a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-fontfamily">FontFamily</a> object that specifies a generic sans serif typeface.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-font">Font</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-fontfamily">FontFamily</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-text-and-fonts-use">Using Text and Fonts</a>
 

 

