---
UID: NF:gdiplusheaders.Image.GetHorizontalResolution
title: Image::GetHorizontalResolution (gdiplusheaders.h)
description: The Image::GetHorizontalResolution method gets the horizontal resolution, in dots per inch, of this image.
old-location: gdiplus\_gdiplus_CLASS_Image_GetHorizontalResolution_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\imageclass\imagemethods\gethorizontalresolution.htm
ms.date: 12/05/2018
ms.keywords: GetHorizontalResolution, GetHorizontalResolution method [GDI+], GetHorizontalResolution method [GDI+],Image class, Image class [GDI+],GetHorizontalResolution method, Image.GetHorizontalResolution, Image::GetHorizontalResolution, _gdiplus_CLASS_Image_GetHorizontalResolution_, gdiplus._gdiplus_CLASS_Image_GetHorizontalResolution_
f1_keywords:
- gdiplusheaders/Image.GetHorizontalResolution
dev_langs:
- c++
req.header: gdiplusheaders.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Image.GetHorizontalResolution
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Image::GetHorizontalResolution


## -description


The <b>Image::GetHorizontalResolution</b> method gets the horizontal resolution, in dots per inch, of this image.


## -parameters






## -returns



Type: <strong>Type: <b>REAL</b>
</strong>

This method returns the horizontal resolution, in dots per inch, of this image.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-bitmap">Bitmap</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-image">Image</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-image-getheight">Image::GetHeight</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-image-getverticalresolution">Image::GetVerticalResolution</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-image-getwidth">Image::GetWidth</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-images-bitmaps-and-metafiles-about">Images, Bitmaps, and Metafiles</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-images-bitmaps-and-metafiles-use">Using Images, Bitmaps, and Metafiles</a>
 

 

