---
UID: NL:gdiplusimaging.BitmapData
title: BitmapData (gdiplusimaging.h)
description: The BitmapData class is used by the Bitmap::LockBits and Bitmap::UnlockBits methods of the Bitmap class. A BitmapData object stores attributes of a bitmap.
old-location: gdiplus\_gdiplus_CLASS_BitmapData_Class.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\bitmapdata.htm
ms.date: 12/05/2018
ms.keywords: BitmapData, BitmapData class [GDI+], BitmapData class [GDI+],described, _gdiplus_CLASS_BitmapData_Class, gdiplus._gdiplus_CLASS_BitmapData_Class, gdiplusimaging/BitmapData
f1_keywords:
- gdiplusimaging/BitmapData
dev_langs:
- c++
req.header: gdiplusimaging.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.lib
- Gdiplus.dll
api_name:
- BitmapData
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# BitmapData class


## -description


The <b>BitmapData</b> class is used by the 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-bitmap-lockbits">Bitmap::LockBits</a> and 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-bitmap-unlockbits">Bitmap::UnlockBits</a> methods of the 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-bitmap">Bitmap</a> class. A <b>BitmapData</b> object stores attributes of a bitmap.

<b xmlns:loc="http://microsoft.com/wdcml/l10n">BitmapData</b> has these types of members:

