---
UID: NL:gdiplusimaging.EncoderParameter
title: EncoderParameter (gdiplusimaging.h)
description: An EncoderParameter object holds a parameter that can be passed to an image encoder. An EncoderParameter object can also be used to receive a list of possible values supported by a particular parameter of a particular image encoder.
old-location: gdiplus\_gdiplus_CLASS_EncoderParameter_Class.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\encoderparameter.htm
ms.date: 12/05/2018
ms.keywords: EncoderParameter, EncoderParameter class [GDI+], EncoderParameter class [GDI+],described, _gdiplus_CLASS_EncoderParameter_Class, gdiplus._gdiplus_CLASS_EncoderParameter_Class, gdiplusimaging/EncoderParameter
f1_keywords:
- gdiplusimaging/EncoderParameter
dev_langs:
- c++
req.header: gdiplusimaging.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.lib
- Gdiplus.dll
api_name:
- EncoderParameter
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# EncoderParameter class


## -description


An <b>EncoderParameter</b> object holds a parameter that can be passed to an image encoder. An <b>EncoderParameter</b> object can also be used to receive a list of possible values supported by a particular parameter of a particular image encoder.

<b xmlns:loc="http://microsoft.com/wdcml/l10n">EncoderParameter</b> has these types of members:


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusenums/ne-gdiplusenums-encoderparametervaluetype">EncoderParameterValueType</a>



<a href="https://docs.microsoft.com/previous-versions/ms534435(v=vs.85)">EncoderParameters</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-image-getencoderparameterlist">Image::GetEncoderParameterList</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nf-gdiplusheaders-image-getencoderparameterlistsize">Image::GetEncoderParameterListSize</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-image-encoders-and-decoders-use">Using Image Encoders and Decoders</a>
 

 

