---
UID: NF:gdipluslinecaps.AdjustableArrowCap.SetHeight
title: AdjustableArrowCap::SetHeight (gdipluslinecaps.h)
description: The AdjustableArrowCap::SetHeight method sets the height of the arrow cap. This is the distance from the base of the arrow to its vertex.
old-location: gdiplus\_gdiplus_CLASS_AdjustableArrowCap_SetHeight_height_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\adjustablearrowcapclass\adjustablearrowcapmethods\setheight.htm
ms.date: 12/05/2018
ms.keywords: AdjustableArrowCap class [GDI+],SetHeight method, AdjustableArrowCap.SetHeight, AdjustableArrowCap::SetHeight, SetHeight, SetHeight method [GDI+], SetHeight method [GDI+],AdjustableArrowCap class, _gdiplus_CLASS_AdjustableArrowCap_SetHeight_height_, gdiplus._gdiplus_CLASS_AdjustableArrowCap_SetHeight_height_
f1_keywords:
- gdipluslinecaps/AdjustableArrowCap.SetHeight
dev_langs:
- c++
req.header: gdipluslinecaps.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- AdjustableArrowCap.SetHeight
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# AdjustableArrowCap::SetHeight


## -description


The <b>AdjustableArrowCap::SetHeight</b> method sets the height of the arrow cap. This is the distance from the base of the arrow to its vertex.


## -parameters




### -param height [in]

Type: <b>REAL</b>

Real number that specifies the height, in units, for the arrow cap. 


## -returns



Type: <strong>Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/ne-gdiplustypes-status">Status</a></b>
</strong>

If the method succeeds, it returns Ok, which is an element of the 
						<b>Status</b> enumeration.

If the method fails, it returns one of the other elements of the 
						<b>Status</b> enumeration.



