---
UID: NF:gdipluslinecaps.AdjustableArrowCap.SetWidth
title: AdjustableArrowCap::SetWidth (gdipluslinecaps.h)
description: The AdjustableArrowCap::SetWidth method sets the width of the arrow cap. The width is the distance between the endpoints of the base of the arrow.
old-location: gdiplus\_gdiplus_CLASS_AdjustableArrowCap_SetWidth_width_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\adjustablearrowcapclass\adjustablearrowcapmethods\setwidth.htm
ms.date: 12/05/2018
ms.keywords: AdjustableArrowCap class [GDI+],SetWidth method, AdjustableArrowCap.SetWidth, AdjustableArrowCap::SetWidth, SetWidth, SetWidth method [GDI+], SetWidth method [GDI+],AdjustableArrowCap class, _gdiplus_CLASS_AdjustableArrowCap_SetWidth_width_, gdiplus._gdiplus_CLASS_AdjustableArrowCap_SetWidth_width_
f1_keywords:
- gdipluslinecaps/AdjustableArrowCap.SetWidth
dev_langs:
- c++
req.header: gdipluslinecaps.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- AdjustableArrowCap.SetWidth
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# AdjustableArrowCap::SetWidth


## -description


The <b>AdjustableArrowCap::SetWidth</b> method sets the width of the arrow cap. The width is the distance between the endpoints of the base of the arrow.


## -parameters




### -param width [in]

Type: <b>REAL</b>

Real number that specifies the distance, in units, between the two corners of the base of the arrow. 


## -returns



Type: <strong>Type: <b><a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/ne-gdiplustypes-status">Status</a></b>
</strong>

If the method succeeds, it returns Ok, which is an element of the 
						<b>Status</b> enumeration.

If the method fails, it returns one of the other elements of the 
						<b>Status</b> enumeration.



