---
UID: NF:gdiplusmetaheader.MetafileHeader.GetDpiY
title: MetafileHeader::GetDpiY (gdiplusmetaheader.h)
description: The MetafileHeader::GetDpiY method gets the vertical dots per inch of the associated metafile.
old-location: gdiplus\_gdiplus_CLASS_MetafileHeader_GetDpiY_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\metafileheaderclass\metafileheadermethods\getdpiy_82.htm
ms.date: 12/05/2018
ms.keywords: GetDpiY, GetDpiY method [GDI+], GetDpiY method [GDI+],MetafileHeader class, MetafileHeader class [GDI+],GetDpiY method, MetafileHeader.GetDpiY, MetafileHeader::GetDpiY, _gdiplus_CLASS_MetafileHeader_GetDpiY_, gdiplus._gdiplus_CLASS_MetafileHeader_GetDpiY_
f1_keywords:
- gdiplusmetaheader/MetafileHeader.GetDpiY
dev_langs:
- c++
req.header: gdiplusmetaheader.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- MetafileHeader.GetDpiY
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# MetafileHeader::GetDpiY


## -description


The <b>MetafileHeader::GetDpiY</b> method gets the vertical dots per inch of the associated metafile.


## -parameters






## -returns



Type: <strong>Type: <b>REAL</b>
</strong>

This method returns a real number that specifies the vertical dots per inch of the associated metafile.




## -see-also




<a href="https://docs.microsoft.com/previous-versions/ms535280(v=vs.85)">GetMetafileHeader</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-loading-and-displaying-metafiles-use">Loading and Displaying Metafiles</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusheaders/nl-gdiplusheaders-metafile">Metafile</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusmetaheader/nl-gdiplusmetaheader-metafileheader">MetafileHeader</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusmetaheader/nf-gdiplusmetaheader-metafileheader-getdpix">MetafileHeader::GetDpiX</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-metafiles-about">Metafiles</a>
 

 

