---
UID: NS:gdiplusmetaheader.__unnamed_struct_1
title: PWMFRect16 (gdiplusmetaheader.h)
description: The PWMFRect16 structure defines a rectangle that bounds a placeable metafile. The rectangle defines the size and position of the metafile.
old-location: gdiplus\_gdiplus_STRUC_PWMFRect16.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\structures\pwmfrect16.htm
ms.date: 12/05/2018
ms.keywords: PWMFRect16, PWMFRect16 structure [GDI+], _gdiplus_STRUC_PWMFRect16, gdiplus._gdiplus_STRUC_PWMFRect16, gdiplusmetaheader/PWMFRect16
f1_keywords:
- gdiplusmetaheader/PWMFRect16
dev_langs:
- c++
req.header: gdiplusmetaheader.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- Gdiplusmetaheader.h
api_name:
- PWMFRect16
targetos: Windows
req.typenames: PWMFRect16
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# PWMFRect16 structure


## -description


The <b>PWMFRect16</b> structure defines a rectangle that bounds a placeable metafile. The rectangle defines the size and position of the metafile.


## -struct-fields




### -field Left

Type: <b>INT16</b>

Left coordinate of the rectangle that bounds the metafile. 


### -field Top

Type: <b>INT16</b>

Top coordinate of the rectangle that bounds the metafile. 


### -field Right

Type: <b>INT16</b>

Right coordinate of the rectangle that bounds the metafile. 


### -field Bottom

Type: <b>INT16</b>

Bottom coordinate of the rectangle that bounds the metafile. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplusmetaheader/ns-gdiplusmetaheader-wmfplaceablefileheader">WmfPlaceableFileHeader</a>
 

 

