---
UID: NF:gdiplustypes.PointF.PointF(IN const PointF &)
title: PointF::PointF(IN const PointF &) (gdiplustypes.h)
description: Creates a new PointF object and copies the data from another PointF object.
old-location: gdiplus\_gdiplus_CLASS_PointF_PointF_point_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\pointfclass\pointfconstructors\pointf_92point.htm
ms.date: 12/05/2018
ms.keywords: PointF, PointF class [GDI+],PointF constructor, PointF constructor [GDI+], PointF constructor [GDI+],PointF class, PointF.PointF, PointF.PointF(IN const PointF &), PointF.PointF(const PointF&), PointF::PointF, PointF::PointF(IN const PointF &), _gdiplus_CLASS_PointF_PointF_point_, gdiplus._gdiplus_CLASS_PointF_PointF_point_
f1_keywords:
- gdiplustypes/PointF.PointF
dev_langs:
- c++
req.header: gdiplustypes.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- PointF.PointF
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# PointF::PointF(IN const PointF &)


## -description


Creates a new <a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-pointf">PointF</a> object and copies the data from another <b>PointF</b> object.


## -parameters




### -param point [in, ref]

Type: <b>const <a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-pointf">PointF</a></b>

Reference to a <a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-pointf">PointF</a> object whose 
					<b>X</b> and 
					<b>Y</b> data members are copied into the 
					<b>X</b> and 
					<b>Y</b> data members of the new <b>PointF</b> object. 


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-point">Point</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-pointf">PointF</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-class-pointf-constructors">PointF Constructors</a>
 

 

