---
UID: NF:gdiplustypes.Rect.Offset(IN INT,IN INT)
title: Rect::Offset(IN INT,IN INT) (gdiplustypes.h)
description: The Rect::Offset method moves the rectangle by dx horizontally and by dy vertically.
old-location: gdiplus\_gdiplus_CLASS_Rect_Offset_dx_dy_.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\rectclass\rectmethods\rectoffsetmethods\offset.htm
ms.date: 12/05/2018
ms.keywords: Offset, Offset method [GDI+], Offset method [GDI+],Rect class, Rect class [GDI+],Offset method, Rect.Offset, Rect.Offset(IN INT,IN INT), Rect.Offset(INT,INT), Rect::Offset, Rect::Offset(IN INT,IN INT), _gdiplus_CLASS_Rect_Offset_dx_dy_, gdiplus._gdiplus_CLASS_Rect_Offset_dx_dy_
f1_keywords:
- gdiplustypes/Rect.Offset
dev_langs:
- c++
req.header: gdiplustypes.h
req.include-header: Gdiplus.h
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional [desktop apps only]
req.target-min-winversvr: Windows 2000 Server [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Gdiplus.lib
req.dll: Gdiplus.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Gdiplus.dll
api_name:
- Rect.Offset
targetos: Windows
req.typenames: 
req.redist: 
req.product: GDI+ 1.0
ms.custom: 19H1
---

# Rect::Offset(IN INT,IN INT)


## -description


The <b>Rect::Offset</b> method moves the rectangle by 
			<i>dx</i> horizontally and by 
			<i>dy</i> vertically.


## -parameters




### -param dx [in]

Type: <b>INT</b>

Integer that specifies the amount to move the rectangle horizontally. 


### -param dy [in]

Type: <b>INT</b>

Integer that specifies the amount to move the rectangle vertically. 


## -returns



This method does not return a value.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nf-gdiplustypes-rect-offset(inint_inint)">Offset Methods</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-pens-lines-and-rectangles-about">Pens, Lines, and Rectangles</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-rect">Rect</a>



<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-rectf">RectF</a>



<a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-using-a-pen-to-draw-lines-and-rectangles-use">Using a Pen to Draw Lines and Rectangles</a>
 

 

