---
UID: NF:gdiplustypes.RectF.Contains(IN REAL,IN REAL)
title: RectF::Contains (gdiplustypes.h)
description: This topic lists the Contains methods of the RectF class. For a complete list of methods for the RectF class, see RectF Methods.
old-location: gdiplus\_gdiplus_CLASS_RectF_Contains_Methods.htm
tech.root: gdiplus
ms.assetid: VS|gdicpp|~\gdiplus\gdiplusreference\classes\rectfclass\rectfmethods\rectfcontainsmethods.htm
ms.date: 12/05/2018
ms.keywords: Contains, Contains methods [GDI+], RectF.Contains, RectF::Contains, _gdiplus_CLASS_RectF_Contains_Methods, gdiplus._gdiplus_CLASS_RectF_Contains_Methods, gdiplustypes/Contains
f1_keywords:
- gdiplustypes/RectF.Contains
dev_langs:
- c++
req.header: gdiplustypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- gdiplustypes.h
api_name:
- RectF.Contains
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# RectF::Contains


## -description


<span>This topic lists the 
			Contains methods of the 
			<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nl-gdiplustypes-rectf">RectF</a> class. For a complete list of methods for the 
			<b>RectF</b> class, see <a href="https://docs.microsoft.com/windows/desktop/gdiplus/-gdiplus-class-rectf-methods">RectF Methods</a>. 
</span><h3>Overload list</h3><table>
<tr>
<th align="left" width="37%">Method</th>
<th align="left" width="63%">Description</th>
</tr>
<tr>
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nf-gdiplustypes-rectf-contains(inconstrectf_)">Contains(RectF&)</a>
</td>
<td align="left" width="63%">
The <a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nf-gdiplustypes-rectf-contains(inconstrectf_)">RectF::Contains</a> method determines whether another rectangle is inside this rectangle.

</td>
</tr>
<tr>
<td align="left" width="37%">
<a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nf-gdiplustypes-rectf-contains(inconstpointf_)">Contains(PointF&)</a>
</td>
<td align="left" width="63%">
The <a href="https://docs.microsoft.com/windows/desktop/api/gdiplustypes/nf-gdiplustypes-rectf-contains(inconstpointf_)">RectF::Contains</a> method determines whether a point is inside this rectangle.

</td>
</tr>
<tr>
<td align="left" width="37%">
<a href="https://docs.microsoft.com/previous-versions/ms534956(v=vs.85)">Contains(REAL,REAL)</a>
</td>
<td align="left" width="63%">
The <a href="https://docs.microsoft.com/previous-versions/ms534956(v=vs.85)">RectF::Contains</a> method determines whether the point (<i>x</i>, <i>y</i>) is inside this rectangle.

</td>
</tr>
</table>

## -parameters

